/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.api.osgi;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.opendaylight.controller.config.api.osgi.ServiceNotFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WaitingServiceTracker<T>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(WaitingServiceTracker.class);
    public static final long FIVE_MINUTES = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
    private final ServiceTracker<T, ?> tracker;
    private final Class<T> serviceInterface;

    private WaitingServiceTracker(Class<T> serviceInterface, ServiceTracker<T, ?> tracker) {
        this.tracker = tracker;
        this.serviceInterface = serviceInterface;
    }

    public T waitForService(long timeoutInMillis) throws ServiceNotFoundException {
        try {
            Object service = this.tracker.waitForService(timeoutInMillis);
            if (service == null) {
                throw new ServiceNotFoundException(String.format("OSGi Service %s was not found after %d ms", this.serviceInterface, timeoutInMillis));
            }
            return (T)service;
        }
        catch (InterruptedException e) {
            throw new ServiceNotFoundException(String.format("Wait for OSGi service %s was interrrupted", this.serviceInterface), e);
        }
    }

    public static <T> WaitingServiceTracker<T> create(@Nonnull Class<T> serviceInterface, @Nonnull BundleContext context) {
        ServiceTracker tracker = new ServiceTracker(context, serviceInterface, null);
        tracker.open();
        return new WaitingServiceTracker<T>(serviceInterface, tracker);
    }

    public static <T> WaitingServiceTracker<T> create(@Nonnull Class<T> serviceInterface, @Nonnull BundleContext context, @Nonnull String filter) {
        String newFilter = String.format("(&(%s=%s)%s)", "objectClass", serviceInterface.getName(), filter);
        try {
            ServiceTracker tracker = new ServiceTracker(context, context.createFilter(newFilter), null);
            tracker.open();
            return new WaitingServiceTracker<T>(serviceInterface, tracker);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid OSGi filter %s", newFilter), e);
        }
    }

    @Override
    public void close() {
        this.tracker.close();
    }
}

