/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.api.jmx.ConfigRegistryMXBean;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.api.jmx.ServiceReferenceMXBean;
import org.opendaylight.controller.config.api.jmx.constants.ConfigRegistryConstants;
import org.opendaylight.controller.config.util.ConfigRegistryClient;
import org.opendaylight.controller.config.util.ConfigTransactionJMXClient;

public class ConfigRegistryJMXClient
implements ConfigRegistryClient {
    private final ConfigRegistryMXBean configRegistryMXBeanProxy;
    private final ObjectName configRegistryON;
    private final MBeanServer configMBeanServer;

    public ConfigRegistryJMXClient(MBeanServer configMBeanServer) {
        this(configMBeanServer, OBJECT_NAME);
    }

    private ConfigRegistryJMXClient(MBeanServer configMBeanServer, ObjectName configRegistryON) {
        this.configMBeanServer = configMBeanServer;
        this.configRegistryON = configRegistryON;
        Set<ObjectInstance> searchResult = configMBeanServer.queryMBeans(configRegistryON, null);
        if (searchResult.size() != 1) {
            throw new IllegalStateException("Config registry not found");
        }
        this.configRegistryMXBeanProxy = JMX.newMXBeanProxy(configMBeanServer, configRegistryON, ConfigRegistryMXBean.class, false);
    }

    public static ConfigRegistryJMXClient createWithoutNotifications(MBeanServer configMBeanServer) {
        return new ConfigRegistryJMXClient(configMBeanServer, ConfigRegistryConstants.OBJECT_NAME_NO_NOTIFICATIONS);
    }

    @Override
    public ConfigTransactionJMXClient createTransaction() {
        ObjectName configTransactionControllerON = this.beginConfig();
        return this.getConfigTransactionClient(configTransactionControllerON);
    }

    @Override
    public ConfigTransactionJMXClient getConfigTransactionClient(String transactionName) {
        ObjectName objectName = ObjectNameUtil.createTransactionControllerON(transactionName);
        return this.getConfigTransactionClient(objectName);
    }

    @Override
    public ConfigTransactionJMXClient getConfigTransactionClient(ObjectName objectName) {
        return new ConfigTransactionJMXClient(this.configRegistryMXBeanProxy, objectName, this.configMBeanServer);
    }

    @Deprecated
    public <T> T newMBeanProxy(ObjectName on, Class<T> clazz) {
        ObjectName onObj = ConfigRegistryJMXClient.translateServiceRefIfPossible(on, clazz, this.configMBeanServer);
        return JMX.newMBeanProxy(this.configMBeanServer, onObj, clazz);
    }

    static ObjectName translateServiceRefIfPossible(ObjectName on, Class<?> clazz, MBeanServer configMBeanServer) {
        ObjectName onObj = on;
        if (ObjectNameUtil.isServiceReference(onObj) && !clazz.equals(ServiceReferenceMXBean.class)) {
            ServiceReferenceMXBean proxy = JMX.newMXBeanProxy(configMBeanServer, onObj, ServiceReferenceMXBean.class);
            onObj = proxy.getCurrentImplementation();
        }
        return onObj;
    }

    public <T> T newMXBeanProxy(ObjectName on, Class<T> clazz) {
        return JMX.newMXBeanProxy(this.configMBeanServer, on, clazz);
    }

    @Override
    public ObjectName beginConfig() {
        return this.configRegistryMXBeanProxy.beginConfig();
    }

    @Override
    public CommitStatus commitConfig(ObjectName transactionControllerON) throws ConflictingVersionException, ValidationException {
        return this.configRegistryMXBeanProxy.commitConfig(transactionControllerON);
    }

    @Override
    public List<ObjectName> getOpenConfigs() {
        return this.configRegistryMXBeanProxy.getOpenConfigs();
    }

    @Override
    public long getVersion() {
        try {
            return (Long)this.configMBeanServer.getAttribute(this.configRegistryON, "Version");
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> getAvailableModuleNames() {
        return this.configRegistryMXBeanProxy.getAvailableModuleNames();
    }

    @Override
    public boolean isHealthy() {
        return this.configRegistryMXBeanProxy.isHealthy();
    }

    @Override
    public Set<ObjectName> lookupConfigBeans() {
        return this.configRegistryMXBeanProxy.lookupConfigBeans();
    }

    @Override
    public Set<ObjectName> lookupConfigBeans(String moduleName) {
        return this.configRegistryMXBeanProxy.lookupConfigBeans(moduleName);
    }

    @Override
    public Set<ObjectName> lookupConfigBeans(String moduleName, String instanceName) {
        return this.configRegistryMXBeanProxy.lookupConfigBeans(moduleName, instanceName);
    }

    @Override
    public ObjectName lookupConfigBean(String moduleName, String instanceName) throws InstanceNotFoundException {
        return this.configRegistryMXBeanProxy.lookupConfigBean(moduleName, instanceName);
    }

    @Override
    public Set<ObjectName> lookupRuntimeBeans() {
        return this.configRegistryMXBeanProxy.lookupRuntimeBeans();
    }

    @Override
    public Set<ObjectName> lookupRuntimeBeans(String ifcName, String instanceName) {
        return this.configRegistryMXBeanProxy.lookupRuntimeBeans(ifcName, instanceName);
    }

    @Override
    public void checkConfigBeanExists(ObjectName objectName) throws InstanceNotFoundException {
        this.configRegistryMXBeanProxy.checkConfigBeanExists(objectName);
    }

    @Override
    public ObjectName lookupConfigBeanByServiceInterfaceName(String serviceInterfaceQName, String refName) {
        return this.configRegistryMXBeanProxy.lookupConfigBeanByServiceInterfaceName(serviceInterfaceQName, refName);
    }

    @Override
    public Map<String, Map<String, ObjectName>> getServiceMapping() {
        return this.configRegistryMXBeanProxy.getServiceMapping();
    }

    @Override
    public Map<String, ObjectName> lookupServiceReferencesByServiceInterfaceName(String serviceInterfaceQName) {
        return this.configRegistryMXBeanProxy.lookupServiceReferencesByServiceInterfaceName(serviceInterfaceQName);
    }

    @Override
    public Set<String> lookupServiceInterfaceNames(ObjectName objectName) throws InstanceNotFoundException {
        return this.configRegistryMXBeanProxy.lookupServiceInterfaceNames(objectName);
    }

    @Override
    public String getServiceInterfaceName(String namespace, String localName) {
        return this.configRegistryMXBeanProxy.getServiceInterfaceName(namespace, localName);
    }

    @Override
    public Object invokeMethod(ObjectName on, String name, Object[] params, String[] signature) {
        try {
            return this.configMBeanServer.invoke(on, name, params, signature);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new RuntimeException("Unable to invoke operation " + name + " on " + on + " with attributes " + Arrays.toString(params) + " and signature " + Arrays.toString(signature), e);
        }
    }

    @Override
    public Object getAttributeCurrentValue(ObjectName on, String attributeName) {
        try {
            return this.configMBeanServer.getAttribute(on, attributeName);
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new RuntimeException("Unable to get attribute " + attributeName + " for " + on + ". Available beans: " + this.lookupConfigBeans(), e);
        }
    }

    @Override
    public Set<String> getAvailableModuleFactoryQNames() {
        return this.configRegistryMXBeanProxy.getAvailableModuleFactoryQNames();
    }

    @Override
    public ObjectName getServiceReference(String serviceInterfaceQName, String refName) throws InstanceNotFoundException {
        return this.configRegistryMXBeanProxy.getServiceReference(serviceInterfaceQName, refName);
    }

    @Override
    public void checkServiceReferenceExists(ObjectName objectName) throws InstanceNotFoundException {
        this.configRegistryMXBeanProxy.checkServiceReferenceExists(objectName);
    }
}

