/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.util;

import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.config.api.ValidationException;
import org.opendaylight.controller.config.api.jmx.CommitStatus;
import org.opendaylight.controller.config.api.jmx.ConfigRegistryMXBean;
import org.opendaylight.controller.config.api.jmx.ConfigTransactionControllerMXBean;
import org.opendaylight.controller.config.api.jmx.ObjectNameUtil;
import org.opendaylight.controller.config.util.ConfigRegistryJMXClient;
import org.opendaylight.controller.config.util.ConfigTransactionClient;

public class ConfigTransactionJMXClient
implements ConfigTransactionClient {
    private final ConfigRegistryMXBean configRegistryMXBeanProxy;
    private final ObjectName configTransactionControllerON;
    private final ConfigTransactionControllerMXBean configTransactionControllerMXBeanProxy;
    private final MBeanServer configMBeanServer;

    public ConfigTransactionJMXClient(ConfigRegistryMXBean configRegistryMXBeanProxy, ObjectName configTransactionControllerON, MBeanServer configMBeanServer) {
        this.configMBeanServer = configMBeanServer;
        this.configRegistryMXBeanProxy = configRegistryMXBeanProxy;
        this.configTransactionControllerON = configTransactionControllerON;
        this.configTransactionControllerMXBeanProxy = JMX.newMXBeanProxy(configMBeanServer, configTransactionControllerON, ConfigTransactionControllerMXBean.class);
    }

    public <T> T newMXBeanProxy(ObjectName on, Class<T> clazz) {
        ObjectName onName = on;
        onName = ObjectNameUtil.withTransactionName(onName, this.getTransactionName());
        onName = ConfigRegistryJMXClient.translateServiceRefIfPossible(onName, clazz, this.configMBeanServer);
        onName = ObjectNameUtil.withTransactionName(onName, this.getTransactionName());
        return JMX.newMXBeanProxy(this.configMBeanServer, onName, clazz);
    }

    @Deprecated
    public <T> T newMBeanProxy(ObjectName on, Class<T> clazz) {
        return JMX.newMBeanProxy(this.configMBeanServer, on, clazz);
    }

    @Override
    public CommitStatus commit() throws ConflictingVersionException, ValidationException {
        return this.configRegistryMXBeanProxy.commitConfig(this.configTransactionControllerON);
    }

    @Override
    public void assertVersion(int expectedParentVersion, int expectedCurrentVersion) {
        if ((long)expectedParentVersion != this.getParentVersion()) {
            throw new IllegalStateException();
        }
        if ((long)expectedCurrentVersion != this.getVersion()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public ObjectName createModule(String moduleName, String instanceName) throws InstanceAlreadyExistsException {
        return this.configTransactionControllerMXBeanProxy.createModule(moduleName, instanceName);
    }

    @Override
    public void reCreateModule(ObjectName objectName) throws InstanceNotFoundException {
        this.configTransactionControllerMXBeanProxy.reCreateModule(objectName);
    }

    @Override
    public void destroyModule(ObjectName objectName) throws InstanceNotFoundException {
        this.configTransactionControllerMXBeanProxy.destroyModule(objectName);
    }

    @Override
    @Deprecated
    public void destroyConfigBean(String moduleName, String instanceName) throws InstanceNotFoundException {
        this.destroyModule(ObjectNameUtil.createTransactionModuleON(this.getTransactionName(), moduleName, instanceName));
    }

    @Override
    public void destroyModule(String moduleName, String instanceName) throws InstanceNotFoundException {
        this.destroyModule(ObjectNameUtil.createTransactionModuleON(this.getTransactionName(), moduleName, instanceName));
    }

    @Override
    public void abortConfig() {
        this.configTransactionControllerMXBeanProxy.abortConfig();
    }

    @Override
    public void validateConfig() throws ValidationException {
        this.configTransactionControllerMXBeanProxy.validateConfig();
    }

    @Override
    public long getParentVersion() {
        try {
            return (Long)this.configMBeanServer.getAttribute(this.configTransactionControllerON, "ParentVersion");
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getVersion() {
        try {
            return (Long)this.configMBeanServer.getAttribute(this.configTransactionControllerON, "Version");
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getTransactionName() {
        return this.configTransactionControllerMXBeanProxy.getTransactionName();
    }

    @Override
    public Set<String> getAvailableModuleNames() {
        return this.configTransactionControllerMXBeanProxy.getAvailableModuleNames();
    }

    @Override
    public ObjectName getObjectName() {
        return this.configTransactionControllerON;
    }

    @Override
    public Set<ObjectName> lookupConfigBeans() {
        return this.configTransactionControllerMXBeanProxy.lookupConfigBeans();
    }

    @Override
    public Set<ObjectName> lookupConfigBeans(String moduleName) {
        return this.configTransactionControllerMXBeanProxy.lookupConfigBeans(moduleName);
    }

    @Override
    public ObjectName lookupConfigBean(String moduleName, String instanceName) throws InstanceNotFoundException {
        return this.configTransactionControllerMXBeanProxy.lookupConfigBean(moduleName, instanceName);
    }

    @Override
    public Set<ObjectName> lookupConfigBeans(String moduleName, String instanceName) {
        return this.configTransactionControllerMXBeanProxy.lookupConfigBeans(moduleName, instanceName);
    }

    @Override
    public void checkConfigBeanExists(ObjectName objectName) throws InstanceNotFoundException {
        this.configTransactionControllerMXBeanProxy.checkConfigBeanExists(objectName);
    }

    @Override
    public ObjectName saveServiceReference(String serviceInterfaceName, String refName, ObjectName moduleON) throws InstanceNotFoundException {
        return this.configTransactionControllerMXBeanProxy.saveServiceReference(serviceInterfaceName, refName, moduleON);
    }

    @Override
    public void removeServiceReference(String serviceInterfaceName, String refName) throws InstanceNotFoundException {
        this.configTransactionControllerMXBeanProxy.removeServiceReference(serviceInterfaceName, refName);
    }

    @Override
    public void removeAllServiceReferences() {
        this.configTransactionControllerMXBeanProxy.removeAllServiceReferences();
    }

    @Override
    public ObjectName lookupConfigBeanByServiceInterfaceName(String serviceInterfaceQName, String refName) {
        return this.configTransactionControllerMXBeanProxy.lookupConfigBeanByServiceInterfaceName(serviceInterfaceQName, refName);
    }

    @Override
    public Map<String, Map<String, ObjectName>> getServiceMapping() {
        return this.configTransactionControllerMXBeanProxy.getServiceMapping();
    }

    @Override
    public Map<String, ObjectName> lookupServiceReferencesByServiceInterfaceName(String serviceInterfaceQName) {
        return this.configTransactionControllerMXBeanProxy.lookupServiceReferencesByServiceInterfaceName(serviceInterfaceQName);
    }

    @Override
    public Set<String> lookupServiceInterfaceNames(ObjectName objectName) throws InstanceNotFoundException {
        return this.configTransactionControllerMXBeanProxy.lookupServiceInterfaceNames(objectName);
    }

    @Override
    public String getServiceInterfaceName(String namespace, String localName) {
        return this.configTransactionControllerMXBeanProxy.getServiceInterfaceName(namespace, localName);
    }

    @Override
    public boolean removeServiceReferences(ObjectName objectName) throws InstanceNotFoundException {
        return this.configTransactionControllerMXBeanProxy.removeServiceReferences(objectName);
    }

    @Override
    public ObjectName getServiceReference(String serviceInterfaceQName, String refName) throws InstanceNotFoundException {
        return this.configTransactionControllerMXBeanProxy.getServiceReference(serviceInterfaceQName, refName);
    }

    @Override
    public void checkServiceReferenceExists(ObjectName objectName) throws InstanceNotFoundException {
        this.configTransactionControllerMXBeanProxy.checkServiceReferenceExists(objectName);
    }

    @Override
    public Attribute getAttribute(ObjectName on, String attrName) {
        if (ObjectNameUtil.getTransactionName(on) == null) {
            throw new IllegalArgumentException("Not in transaction instance " + on + ", no transaction name present");
        }
        try {
            return new Attribute(attrName, this.configMBeanServer.getAttribute(on, attrName));
        }
        catch (JMException e) {
            throw new IllegalStateException("Unable to get attribute " + attrName + " for " + on, e);
        }
    }

    @Override
    public Object getAttributeCurrentValue(ObjectName on, String attrName) {
        return this.getAttribute(on, attrName).getValue();
    }

    @Override
    public void validateBean(ObjectName configBeanON) throws ValidationException {
        try {
            this.configMBeanServer.invoke(configBeanON, "validate", null, null);
        }
        catch (MBeanException e) {
            Exception targetException = e.getTargetException();
            if (targetException instanceof ValidationException) {
                throw (ValidationException)targetException;
            }
            throw new RuntimeException(e);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAttribute(ObjectName on, String attrName, Attribute attribute) {
        if (ObjectNameUtil.getTransactionName(on) == null) {
            throw new IllegalArgumentException("Not in transaction instance " + on + ", no transaction name present");
        }
        try {
            this.configMBeanServer.setAttribute(on, attribute);
        }
        catch (JMException e) {
            throw new IllegalStateException("Unable to set attribute " + attrName + " for " + on, e);
        }
    }

    @Override
    public Set<String> getAvailableModuleFactoryQNames() {
        return this.configTransactionControllerMXBeanProxy.getAvailableModuleFactoryQNames();
    }

    @Override
    public Set<ObjectName> lookupRuntimeBeans() {
        return this.configTransactionControllerMXBeanProxy.lookupRuntimeBeans();
    }

    @Override
    public Set<ObjectName> lookupRuntimeBeans(String moduleName, String instanceName) {
        return this.configTransactionControllerMXBeanProxy.lookupRuntimeBeans(moduleName, instanceName);
    }
}

