/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.mdsal.model.ietf.util.Ipv4Utils;
import org.opendaylight.mdsal.model.ietf.util.Ipv6Utils;
import org.opendaylight.yangtools.yang.binding.util.StringValueObjectFactory;

@Beta
public abstract class AbstractIetfInetUtil<A4, P4, A6, P6, A, P> {
    private static final int INET4_LENGTH = 4;
    private static final int INET6_LENGTH = 16;
    private final StringValueObjectFactory<A4> address4Factory;
    private final StringValueObjectFactory<P4> prefix4Factory;
    private final StringValueObjectFactory<A6> address6Factory;
    private final StringValueObjectFactory<P6> prefix6Factory;

    protected AbstractIetfInetUtil(Class<A4> addr4Class, Class<P4> prefix4Class, Class<A6> addr6Class, Class<P6> prefix6Class) {
        this.address4Factory = StringValueObjectFactory.create(addr4Class, "0.0.0.0");
        this.prefix4Factory = StringValueObjectFactory.create(prefix4Class, "0.0.0.0/0");
        this.address6Factory = StringValueObjectFactory.create(addr6Class, "::0");
        this.prefix6Factory = StringValueObjectFactory.create(prefix6Class, "::0/0");
    }

    @Nonnull
    protected abstract A ipv4Address(@Nonnull A4 var1);

    @Nonnull
    protected abstract A ipv6Address(@Nonnull A6 var1);

    @Nonnull
    protected abstract P ipv4Prefix(@Nonnull P4 var1);

    @Nonnull
    protected abstract P ipv6Prefix(@Nonnull P6 var1);

    @Nullable
    protected abstract A4 maybeIpv4Address(@Nonnull A var1);

    @Nullable
    protected abstract A6 maybeIpv6Address(@Nonnull A var1);

    @Nonnull
    protected abstract String ipv4AddressString(@Nonnull A4 var1);

    @Nonnull
    protected abstract String ipv6AddressString(@Nonnull A6 var1);

    @Nonnull
    protected abstract String ipv4PrefixString(@Nonnull P4 var1);

    @Nonnull
    protected abstract String ipv6PrefixString(@Nonnull P6 var1);

    @Nonnull
    public final A ipAddressFor(@Nonnull byte[] bytes) {
        switch (bytes.length) {
            case 4: {
                return this.ipv4Address(this.ipv4AddressFor(bytes));
            }
            case 16: {
                return this.ipv6Address(this.ipv6AddressFor(bytes));
            }
        }
        throw new IllegalArgumentException("Invalid array length " + bytes.length);
    }

    @Nonnull
    public final A ipAddressFor(@Nonnull InetAddress addr) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        if (addr instanceof Inet4Address) {
            return this.ipv4Address(this.ipv4AddressFor(addr));
        }
        if (addr instanceof Inet6Address) {
            return this.ipv6Address(this.ipv6AddressFor(addr));
        }
        throw new IllegalArgumentException("Unhandled address " + addr);
    }

    @Nonnull
    public final P ipPrefixFor(@Nonnull byte[] bytes, int mask) {
        switch (bytes.length) {
            case 4: {
                return this.ipv4Prefix(this.ipv4PrefixFor((A4)bytes, mask));
            }
            case 16: {
                return this.ipv6Prefix(this.ipv6PrefixFor((A6)bytes, mask));
            }
        }
        throw new IllegalArgumentException("Invalid array length " + bytes.length);
    }

    @Nonnull
    public final P ipPrefixFor(@Nonnull InetAddress addr, int mask) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        if (addr instanceof Inet4Address) {
            return this.ipv4Prefix(this.ipv4PrefixFor((A4)addr, mask));
        }
        if (addr instanceof Inet6Address) {
            return this.ipv6Prefix(this.ipv6PrefixFor((A6)addr, mask));
        }
        throw new IllegalArgumentException("Unhandled address " + addr);
    }

    @Nonnull
    public final InetAddress inetAddressFor(@Nonnull A addr) {
        A4 v4 = this.maybeIpv4Address(addr);
        if (v4 != null) {
            return this.inet4AddressFor(v4);
        }
        A6 v6 = this.maybeIpv6Address(addr);
        Preconditions.checkArgument(v6 != null, "Address %s is neither IPv4 nor IPv6", addr);
        return this.inet6AddressFor(v6);
    }

    @Nonnull
    public final Inet4Address inet4AddressFor(@Nonnull A4 addr) {
        try {
            return (Inet4Address)InetAddress.getByAddress(this.ipv4AddressBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    @Nonnull
    public final Inet6Address inet6AddressFor(@Nonnull A6 addr) {
        try {
            return (Inet6Address)InetAddress.getByAddress(this.ipv6AddressBytes(addr));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid address " + addr, e);
        }
    }

    @Nonnull
    public final A4 ipv4AddressFor(@Nonnull byte[] bytes) {
        return this.address4Factory.newInstance(AbstractIetfInetUtil.addressStringV4(bytes));
    }

    @Nonnull
    public final A4 ipv4AddressFor(@Nonnull InetAddress addr) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet4Address, "Address has to be an Inet4Address");
        return this.address4Factory.newInstance(addr.getHostAddress());
    }

    @Nonnull
    public final A4 ipv4AddressFrom(@Nonnull P4 prefix) {
        return AbstractIetfInetUtil.prefixToAddress(this.address4Factory, this.ipv4PrefixString(prefix));
    }

    @Nonnull
    public final byte[] ipv4AddressBytes(@Nonnull A4 addr) {
        String str = this.ipv4AddressString(addr);
        byte[] bytes = new byte[4];
        int percent = str.indexOf(37);
        Ipv4Utils.fillIpv4Bytes(bytes, 0, str, 0, percent == -1 ? str.length() : percent);
        return bytes;
    }

    @Nonnull
    public final P4 ipv4PrefixFor(@Nonnull byte[] bytes) {
        return this.prefix4Factory.newInstance(AbstractIetfInetUtil.prefixStringV4(bytes));
    }

    @Nonnull
    public final P4 ipv4PrefixFor(@Nonnull byte[] address, int mask) {
        return this.prefix4Factory.newInstance(AbstractIetfInetUtil.prefixStringV4(address, mask));
    }

    @Nonnull
    public final P4 ipv4PrefixForShort(@Nonnull byte[] address, int mask) {
        if (mask == 0) {
            return this.prefix4Factory.getTemplate();
        }
        return this.v4PrefixForShort(address, 0, mask / 8 + (mask % 8 == 0 ? 0 : 1), mask);
    }

    @Nonnull
    public final P4 ipv4PrefixForShort(@Nonnull byte[] array, int startOffset, int mask) {
        if (mask == 0) {
            return this.prefix4Factory.getTemplate();
        }
        return this.v4PrefixForShort(array, startOffset, mask / 8 + (mask % 8 == 0 ? 0 : 1), mask);
    }

    @Nonnull
    public final P4 ipv4PrefixFor(@Nonnull InetAddress addr) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet4Address, "Address has to be an Inet4Address");
        return this.prefix4Factory.newInstance(addr.getHostAddress() + "/32");
    }

    @Nonnull
    public final P4 ipv4PrefixFor(@Nonnull InetAddress addr, int mask) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet4Address, "Address has to be an Inet4Address");
        Preconditions.checkArgument(mask >= 0 && mask <= 32, "Invalid mask %s", mask);
        return this.prefix4Factory.newInstance(addr.getHostAddress() + '/' + mask);
    }

    @Nonnull
    public final P4 ipv4PrefixFor(@Nonnull A4 addr) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        return this.prefix4Factory.newInstance(this.ipv4AddressString(addr) + "/32");
    }

    @Nonnull
    public final P4 ipv4PrefixFor(@Nonnull A4 addr, int mask) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        Preconditions.checkArgument(mask >= 0 && mask <= 32, "Invalid mask %s", mask);
        return this.prefix4Factory.newInstance(this.ipv4AddressString(addr) + '/' + mask);
    }

    @Nonnull
    public final Map.Entry<A4, Integer> splitIpv4Prefix(@Nonnull P4 prefix) {
        return AbstractIetfInetUtil.splitPrefix(this.address4Factory, this.ipv4PrefixString(prefix));
    }

    @Nonnull
    public final byte[] ipv4PrefixToBytes(@Nonnull P4 prefix) {
        String str = this.ipv4PrefixString(prefix);
        int slash = str.lastIndexOf(47);
        byte[] bytes = new byte[5];
        Ipv4Utils.fillIpv4Bytes(bytes, 0, str, 0, slash);
        bytes[4] = (byte)Integer.parseInt(str.substring(slash + 1), 10);
        return bytes;
    }

    @Nonnull
    public final A6 ipv6AddressFor(@Nonnull byte[] bytes) {
        return this.address6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(bytes));
    }

    @Nonnull
    public final A6 ipv6AddressFor(@Nonnull InetAddress addr) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet6Address, "Address has to be an Inet6Address");
        return this.address6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(addr));
    }

    @Nonnull
    public final A6 ipv6AddressFrom(@Nonnull P6 prefix) {
        return AbstractIetfInetUtil.prefixToAddress(this.address6Factory, this.ipv6PrefixString(prefix));
    }

    @Nonnull
    public final byte[] ipv6AddressBytes(@Nonnull A6 addr) {
        String str = this.ipv6AddressString(addr);
        byte[] bytes = new byte[16];
        int percent = str.indexOf(37);
        Ipv6Utils.fillIpv6Bytes(bytes, str, percent == -1 ? str.length() : percent);
        return bytes;
    }

    @Nonnull
    public final P6 ipv6PrefixFor(@Nonnull byte[] bytes) {
        return this.prefix6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(bytes) + "/128");
    }

    @Nonnull
    public final P6 ipv6PrefixFor(@Nonnull byte[] address, int mask) {
        Preconditions.checkArgument(mask >= 0 && mask <= 128, "Invalid mask %s", mask);
        return this.prefix6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(address) + '/' + mask);
    }

    @Nonnull
    public final P6 ipv6PrefixForShort(@Nonnull byte[] address, int mask) {
        return this.ipv6PrefixForShort(address, 0, mask);
    }

    @Nonnull
    public final P6 ipv6PrefixForShort(@Nonnull byte[] array, int startOffset, int mask) {
        if (mask == 0) {
            return this.prefix6Factory.getTemplate();
        }
        Preconditions.checkArgument(mask > 0 && mask <= 128, "Invalid mask %s", mask);
        int size = mask / 8 + (mask % 8 == 0 ? 0 : 1);
        byte[] tmp = new byte[16];
        System.arraycopy(array, startOffset, tmp, 0, size);
        return this.ipv6PrefixFor((A6)tmp, mask);
    }

    @Nonnull
    public final P6 ipv6PrefixFor(@Nonnull InetAddress addr) {
        return this.prefix6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(addr) + "/128");
    }

    @Nonnull
    public final P6 ipv6PrefixFor(@Nonnull InetAddress addr, int mask) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        Preconditions.checkArgument(addr instanceof Inet6Address, "Address has to be an Inet6Address");
        Preconditions.checkArgument(mask >= 0 && mask <= 128, "Invalid mask %s", mask);
        return this.prefix6Factory.newInstance(AbstractIetfInetUtil.addressStringV6(addr) + '/' + mask);
    }

    @Nonnull
    public final P6 ipv6PrefixFor(@Nonnull A6 addr) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        return this.prefix6Factory.newInstance(this.ipv6AddressString(addr) + "/128");
    }

    @Nonnull
    public final P6 ipv6PrefixFor(@Nonnull A6 addr, int mask) {
        Preconditions.checkNotNull(addr, "Address must not be null");
        Preconditions.checkArgument(mask >= 0 && mask <= 128, "Invalid mask %s", mask);
        return this.prefix6Factory.newInstance(this.ipv6AddressString(addr) + '/' + mask);
    }

    @Nonnull
    public final Map.Entry<A6, Integer> splitIpv6Prefix(@Nonnull P6 prefix) {
        return AbstractIetfInetUtil.splitPrefix(this.address6Factory, this.ipv6PrefixString(prefix));
    }

    private static <T> T prefixToAddress(StringValueObjectFactory<T> factory, String str) {
        return factory.newInstance(str.substring(0, str.lastIndexOf(47)));
    }

    private static <T> Map.Entry<T, Integer> splitPrefix(StringValueObjectFactory<T> factory, String str) {
        int slash = str.lastIndexOf(47);
        return new AbstractMap.SimpleImmutableEntry<T, Integer>(factory.newInstance(str.substring(0, slash)), Integer.valueOf(str.substring(slash + 1)));
    }

    @Nonnull
    public final byte[] ipv6PrefixToBytes(@Nonnull P6 prefix) {
        String str = this.ipv6PrefixString(prefix);
        byte[] bytes = new byte[17];
        int slash = str.lastIndexOf(47);
        Ipv6Utils.fillIpv6Bytes(bytes, str, slash);
        bytes[16] = (byte)Integer.parseInt(str.substring(slash + 1), 10);
        return bytes;
    }

    private static void appendIpv4String(StringBuilder sb, byte[] bytes) {
        Preconditions.checkArgument(bytes.length == 4, "IPv4 address length is 4 bytes");
        sb.append(Byte.toUnsignedInt(bytes[0]));
        for (int i = 1; i < 4; ++i) {
            sb.append('.');
            sb.append(Byte.toUnsignedInt(bytes[i]));
        }
    }

    private static String addressStringV4(byte[] bytes) {
        StringBuilder sb = new StringBuilder(15);
        AbstractIetfInetUtil.appendIpv4String(sb, bytes);
        return sb.toString();
    }

    private static String addressStringV6(byte[] bytes) {
        Preconditions.checkArgument(bytes.length == 16, "IPv6 address length is 16 bytes");
        try {
            return AbstractIetfInetUtil.addressStringV6(Inet6Address.getByAddress(bytes));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Invalid input %s", new Object[]{bytes}), e);
        }
    }

    private static String addressStringV6(InetAddress addr) {
        return InetAddresses.toAddrString(addr);
    }

    private static String prefixStringV4(byte[] bytes) {
        StringBuilder sb = new StringBuilder(18);
        AbstractIetfInetUtil.appendIpv4String(sb, bytes);
        sb.append("/32");
        return sb.toString();
    }

    private static String prefixStringV4(byte[] bytes, int mask) {
        Preconditions.checkArgument(mask >= 0 && mask <= 32, "Invalid mask %s", mask);
        StringBuilder sb = new StringBuilder(18);
        AbstractIetfInetUtil.appendIpv4String(sb, bytes);
        sb.append('/');
        sb.append(mask);
        return sb.toString();
    }

    private P4 v4PrefixForShort(@Nonnull byte[] array, int startOffset, int size, int mask) {
        int i;
        if (startOffset == 0 && size == 4 && array.length == 4) {
            return this.ipv4PrefixFor((A4)array, mask);
        }
        StringBuilder sb = new StringBuilder(18);
        sb.append(Byte.toUnsignedInt(array[startOffset]));
        for (i = 1; i < size; ++i) {
            sb.append('.');
            sb.append(Byte.toUnsignedInt(array[startOffset + i]));
        }
        for (i = size; i < 4; ++i) {
            sb.append(".0");
        }
        Preconditions.checkArgument(mask > 0 && mask <= 32, "Invalid mask %s", mask);
        sb.append('/');
        sb.append(mask);
        return this.prefix4Factory.newInstance(sb.toString());
    }
}

