/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.model.ietf.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.binding.util.StringValueObjectFactory;

@Beta
public abstract class AbstractIetfYangUtil<T> {
    private static final int MAC_BYTE_LENGTH = 6;
    private static final char[] HEX_CHARS;
    private static final byte[] HEX_VALUES;
    private final StringValueObjectFactory<T> factory;

    protected AbstractIetfYangUtil(Class<T> clazz) {
        this.factory = StringValueObjectFactory.create(clazz, "00:00:00:00:00:00");
    }

    private static final void appendHexByte(StringBuilder sb, byte b) {
        int v = Byte.toUnsignedInt(b);
        sb.append(HEX_CHARS[v >>> 4]);
        sb.append(HEX_CHARS[v & 0xF]);
    }

    private static boolean ensureLowerCase(@Nonnull char[] chars) {
        boolean ret = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < 'A' || c > 'F') continue;
            chars[i] = Character.toLowerCase(c);
            ret = true;
        }
        return ret;
    }

    @Nonnull
    private static String bytesToString(@Nonnull byte[] bytes) {
        Preconditions.checkArgument(bytes.length == 6, "MAC address should have 6 bytes, not %s", bytes.length);
        StringBuilder sb = new StringBuilder(17);
        AbstractIetfYangUtil.appendHexByte(sb, bytes[0]);
        for (int i = 1; i < 6; ++i) {
            sb.append(':');
            AbstractIetfYangUtil.appendHexByte(sb, bytes[i]);
        }
        return sb.toString();
    }

    @Nonnull
    public final T canonizeMacAddress(@Nonnull T macAddress) {
        char[] input = this.getValue(macAddress).toCharArray();
        if (AbstractIetfYangUtil.ensureLowerCase(input)) {
            return this.factory.newInstance(input.toString());
        }
        return macAddress;
    }

    @Nonnull
    public final T macAddressFor(@Nonnull byte[] bytes) {
        return this.factory.newInstance(AbstractIetfYangUtil.bytesToString(bytes));
    }

    static byte hexValue(char c) {
        byte v;
        try {
            v = HEX_VALUES[c];
        }
        catch (IndexOutOfBoundsException e) {
            v = -1;
        }
        if (v < 0) {
            throw new IllegalArgumentException("Invalid character '" + c + "' encountered");
        }
        return v;
    }

    @Nonnull
    public final byte[] bytesFor(@Nonnull T macAddress) {
        String mac = this.getValue(macAddress);
        byte[] ret = new byte[6];
        int i = 0;
        int base = 0;
        while (i < 6) {
            ret[i] = (byte)(AbstractIetfYangUtil.hexValue(mac.charAt(base)) << 4 | AbstractIetfYangUtil.hexValue(mac.charAt(base + 1)));
            ++i;
            base += 3;
        }
        return ret;
    }

    protected abstract String getValue(T var1);

    static {
        int c;
        HEX_CHARS = "0123456789abcdef".toCharArray();
        byte[] b = new byte[103];
        Arrays.fill(b, (byte)-1);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            b[c] = (byte)(c - 48);
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            b[c] = (byte)(c - 65 + 10);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            b[c] = (byte)(c - 97 + 10);
        }
        HEX_VALUES = b;
    }
}

