/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.ietf.stateful07.Stateful07LSPIdentifierIpv6TlvParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.LspIdentifiers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.LspIdentifiersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.address.family.Ipv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.address.family.Ipv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.address.family.Ipv6Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.address.family.ipv4._case.Ipv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.address.family.ipv4._case.Ipv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Ipv4ExtendedTunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelId;

public final class Stateful07LSPIdentifierIpv4TlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 18;
    private static final int V4_LENGTH = 16;

    @Override
    public LspIdentifiers parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        Preconditions.checkArgument(buffer.readableBytes() == 16, "Length %s does not match LSP Identifiers Ipv4 tlv length.", buffer.readableBytes());
        Ipv4Builder builder = new Ipv4Builder();
        builder.setIpv4TunnelSenderAddress(Ipv4Util.addressForByteBuf(buffer));
        LspId lspId = new LspId(Long.valueOf(buffer.readUnsignedShort()));
        TunnelId tunnelId = new TunnelId(buffer.readUnsignedShort());
        builder.setIpv4ExtendedTunnelId(new Ipv4ExtendedTunnelId(Ipv4Util.addressForByteBuf(buffer)));
        builder.setIpv4TunnelEndpointAddress(Ipv4Util.addressForByteBuf(buffer));
        Ipv4Case afi = new Ipv4CaseBuilder().setIpv4(builder.build()).build();
        return new LspIdentifiersBuilder().setAddressFamily(afi).setLspId(lspId).setTunnelId(tunnelId).build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Ipv4 ipv4;
        Preconditions.checkArgument(tlv instanceof LspIdentifiers, "LspIdentifiersTlv is mandatory.");
        LspIdentifiers lsp = (LspIdentifiers)tlv;
        AddressFamily afi = lsp.getAddressFamily();
        ByteBuf body = Unpooled.buffer();
        if (afi.getImplementedInterface().equals(Ipv6Case.class)) {
            new Stateful07LSPIdentifierIpv6TlvParser().serializeTlv(tlv, buffer);
        }
        Preconditions.checkArgument((ipv4 = ((Ipv4Case)afi).getIpv4()).getIpv4TunnelSenderAddress() != null, "Ipv4TunnelSenderAddress is mandatory.");
        ByteBufWriteUtil.writeIpv4Address(ipv4.getIpv4TunnelSenderAddress(), body);
        Preconditions.checkArgument(lsp.getLspId() != null, "LspId is mandatory.");
        ByteBufWriteUtil.writeShort(lsp.getLspId().getValue().shortValue(), body);
        Preconditions.checkArgument(lsp.getTunnelId() != null, "TunnelId is mandatory.");
        ByteBufWriteUtil.writeUnsignedShort(lsp.getTunnelId().getValue(), body);
        Preconditions.checkArgument(ipv4.getIpv4ExtendedTunnelId() != null, "Ipv4ExtendedTunnelId is mandatory.");
        ByteBufWriteUtil.writeIpv4Address(ipv4.getIpv4ExtendedTunnelId(), body);
        Preconditions.checkArgument(ipv4.getIpv4TunnelEndpointAddress() != null, "Ipv4TunnelEndpointAddress is mandatory.");
        ByteBufWriteUtil.writeIpv4Address(ipv4.getIpv4TunnelEndpointAddress(), body);
        TlvUtil.formatTlv(18, body, buffer);
    }
}

