/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.LspIdentifiers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.LspIdentifiersBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.address.family.Ipv6Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.address.family.Ipv6CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.address.family.ipv6._case.Ipv6;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.address.family.ipv6._case.Ipv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Ipv6ExtendedTunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelId;

public final class Stateful07LSPIdentifierIpv6TlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 19;
    private static final int V6_LENGTH = 52;

    @Override
    public LspIdentifiers parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        Preconditions.checkArgument(buffer.readableBytes() == 52, "Length %s does not match LSP Identifiers Ipv6 tlv length.", buffer.readableBytes());
        Ipv6Builder builder = new Ipv6Builder();
        builder.setIpv6TunnelSenderAddress(Ipv6Util.addressForByteBuf(buffer));
        LspId lspId = new LspId(Long.valueOf(buffer.readUnsignedShort()));
        TunnelId tunnelId = new TunnelId(buffer.readUnsignedShort());
        builder.setIpv6ExtendedTunnelId(new Ipv6ExtendedTunnelId(Ipv6Util.addressForByteBuf(buffer)));
        builder.setIpv6TunnelEndpointAddress(Ipv6Util.addressForByteBuf(buffer));
        Ipv6Case afi = new Ipv6CaseBuilder().setIpv6(builder.build()).build();
        return new LspIdentifiersBuilder().setAddressFamily(afi).setLspId(lspId).setTunnelId(tunnelId).build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof LspIdentifiers, "LspIdentifiersTlv is mandatory.");
        LspIdentifiers lsp = (LspIdentifiers)tlv;
        ByteBuf body = Unpooled.buffer();
        Ipv6 ipv6 = ((Ipv6Case)lsp.getAddressFamily()).getIpv6();
        Preconditions.checkArgument(ipv6.getIpv6TunnelSenderAddress() != null, "Ipv6TunnelSenderAddress is mandatory.");
        ByteBufWriteUtil.writeIpv6Address(ipv6.getIpv6TunnelSenderAddress(), body);
        Preconditions.checkArgument(lsp.getLspId() != null, "LspId is mandatory.");
        ByteBufWriteUtil.writeShort(lsp.getLspId().getValue().shortValue(), body);
        Preconditions.checkArgument(lsp.getTunnelId() != null, "TunnelId is mandatory.");
        ByteBufWriteUtil.writeUnsignedShort(lsp.getTunnelId().getValue(), body);
        Preconditions.checkArgument(ipv6.getIpv6ExtendedTunnelId() != null, "Ipv6ExtendedTunnelId is mandatory.");
        ByteBufWriteUtil.writeIpv6Address(ipv6.getIpv6ExtendedTunnelId(), body);
        Preconditions.checkArgument(ipv6.getIpv6TunnelEndpointAddress() != null, "Ipv6TunnelEndpointAddress is mandatory.");
        ByteBufWriteUtil.writeIpv6Address(ipv6.getIpv6TunnelEndpointAddress(), body);
        TlvUtil.formatTlv(19, body, buffer);
    }
}

