/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.PSTUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.Pcrpt;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.PcrptBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcrpt.message.PcrptMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcrpt.message.pcrpt.message.Reports;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcrpt.message.pcrpt.message.ReportsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcrpt.message.pcrpt.message.reports.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcrpt.message.pcrpt.message.reports.PathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.srp.object.Srp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.Rro;

public class Stateful07PCReportMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 10;

    public Stateful07PCReportMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument(message instanceof Pcrpt, "Wrong instance of Message. Passed instance of %s. Need Pcrpt.", message.getClass());
        Pcrpt msg = (Pcrpt)message;
        List<Reports> reports = msg.getPcrptMessage().getReports();
        ByteBuf buffer = Unpooled.buffer();
        for (Reports report : reports) {
            this.serializeReport(report, buffer);
        }
        MessageUtil.formatMessage(10, buffer, out);
    }

    private void serializeReport(Reports report, ByteBuf buffer) {
        if (report.getSrp() != null) {
            this.serializeObject(report.getSrp(), buffer);
        }
        this.serializeObject(report.getLsp(), buffer);
        Path p = report.getPath();
        if (p != null) {
            this.serializeObject(p.getEro(), buffer);
            this.serializeObject(p.getLspa(), buffer);
            this.serializeObject(p.getBandwidth(), buffer);
            this.serializeObject(p.getReoptimizationBandwidth(), buffer);
            if (p.getMetrics() != null) {
                for (Metrics m : p.getMetrics()) {
                    this.serializeObject(m.getMetric(), buffer);
                }
            }
            this.serializeObject(p.getIro(), buffer);
            this.serializeObject(p.getRro(), buffer);
        }
    }

    @Override
    public Message validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument(objects != null, "Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcrpt message cannot be empty.");
        }
        ArrayList<Reports> reports = Lists.newArrayList();
        while (!objects.isEmpty()) {
            Reports report = this.getValidReports(objects, errors);
            if (report == null) continue;
            reports.add(report);
        }
        return new PcrptBuilder().setPcrptMessage(new PcrptMessageBuilder().setReports(reports).build()).build();
    }

    protected Reports getValidReports(List<Object> objects, List<Message> errors) {
        ReportsBuilder builder = new ReportsBuilder();
        boolean lspViaSR = false;
        Object object = objects.remove(0);
        if (object instanceof Srp) {
            Srp srp = (Srp)object;
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.srp.object.srp.Tlvs tlvs = srp.getTlvs();
            if (tlvs != null) {
                lspViaSR = PSTUtil.isDefaultPST(tlvs.getPathSetupType());
            }
            builder.setSrp(srp);
            object = objects.isEmpty() ? null : objects.remove(0);
        }
        if (Stateful07PCReportMessageParser.validateLsp(object, lspViaSR, errors, builder)) {
            if (!objects.isEmpty() && !Stateful07PCReportMessageParser.validatePath(objects, errors, builder)) {
                return null;
            }
            return builder.build();
        }
        return null;
    }

    private static boolean validateLsp(Object object, boolean lspViaSR, List<Message> errors, ReportsBuilder builder) {
        if (object instanceof Lsp) {
            Lsp lsp = (Lsp)object;
            Tlvs tlvs = lsp.getTlvs();
            if (!(lspViaSR || lsp.getPlspId().getValue() == 0L || tlvs != null && tlvs.getLspIdentifiers() != null)) {
                Message errorMsg = Stateful07PCReportMessageParser.createErrorMsg(PCEPErrors.LSP_IDENTIFIERS_TLV_MISSING, Optional.absent());
                errors.add(errorMsg);
                return false;
            }
            builder.setLsp(lsp);
            return true;
        }
        errors.add(Stateful07PCReportMessageParser.createErrorMsg(PCEPErrors.LSP_MISSING, Optional.absent()));
        return false;
    }

    private static boolean validatePath(List<Object> objects, List<Message> errors, ReportsBuilder builder) {
        PathBuilder pBuilder = new PathBuilder();
        Object object = objects.remove(0);
        if (!(object instanceof Ero)) {
            errors.add(Stateful07PCReportMessageParser.createErrorMsg(PCEPErrors.ERO_MISSING, Optional.absent()));
            return false;
        }
        pBuilder.setEro((Ero)object);
        Stateful07PCReportMessageParser.parsePath(objects, pBuilder);
        builder.setPath(pBuilder.build());
        return true;
    }

    private static void parsePath(List<Object> objects, PathBuilder builder) {
        ArrayList<Metrics> pathMetrics = Lists.newArrayList();
        State state = State.INIT;
        while (!objects.isEmpty() && !state.equals((java.lang.Object)State.END)) {
            Object obj = objects.get(0);
            if ((state = Stateful07PCReportMessageParser.insertObject(state, obj, builder, pathMetrics)).equals((java.lang.Object)State.END)) continue;
            objects.remove(0);
        }
        if (!pathMetrics.isEmpty()) {
            builder.setMetrics(pathMetrics);
        }
    }

    private static State insertObject(State state, Object obj, PathBuilder builder, List<Metrics> pathMetrics) {
        switch (state) {
            case INIT: {
                if (obj instanceof Lspa) {
                    builder.setLspa((Lspa)obj);
                    return State.LSPA_IN;
                }
            }
            case LSPA_IN: {
                if (obj instanceof Bandwidth) {
                    builder.setBandwidth((Bandwidth)obj);
                    return State.LSPA_IN;
                }
                if (obj instanceof ReoptimizationBandwidth) {
                    builder.setReoptimizationBandwidth((ReoptimizationBandwidth)obj);
                    return State.LSPA_IN;
                }
            }
            case BANDWIDTH_IN: {
                if (obj instanceof Metric) {
                    pathMetrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                    return State.BANDWIDTH_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof Iro) {
                    builder.setIro((Iro)obj);
                    return State.IRO_IN;
                }
            }
            case IRO_IN: {
                if (obj instanceof Rro) {
                    builder.setRro((Rro)obj);
                    return State.RRO_IN;
                }
            }
            case RRO_IN: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    private static enum State {
        INIT,
        LSPA_IN,
        BANDWIDTH_IN,
        METRIC_IN,
        IRO_IN,
        RRO_IN,
        END;

    }
}

