/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class PeerRecord {
    @GuardedBy(value="this")
    private final Cache<Short, Short> pastIds;
    @GuardedBy(value="this")
    private Short lastId;

    PeerRecord(long idLifetimeSeconds, Short lastId) {
        this.pastIds = CacheBuilder.newBuilder().expireAfterWrite(idLifetimeSeconds, TimeUnit.SECONDS).maximumSize(255L).build();
        this.lastId = lastId;
    }

    synchronized Short allocId() {
        short id;
        short s = id = this.lastId == null ? (short)0 : this.lastId;
        while (this.pastIds.getIfPresent(id) != null) {
            id = (short)((id + 1) % 255);
        }
        this.pastIds.put(id, id);
        this.lastId = id;
        return id;
    }
}

