/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.MonitoringBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.monitoring.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.monitoring.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;

public class PCEPMonitoringObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    public static final int CLASS = 19;
    public static final int TYPE = 1;
    private static final int FLAGS_SIZE = 24;
    private static final int RESERVED = 1;
    private static final int L_FLAG_POS = 23;
    private static final int G_FLAG_POS = 22;
    private static final int P_FLAG_POS = 21;
    private static final int C_FLAG_POS = 20;
    private static final int I_FLAG_POS = 19;

    public PCEPMonitoringObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg);
    }

    @Override
    public Object parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        MonitoringBuilder builder = new MonitoringBuilder();
        buffer.readBytes(1);
        BitArray flagBits = BitArray.valueOf(buffer, 24);
        Monitoring.Flags flags = new Monitoring.Flags(flagBits.get(22), flagBits.get(19), flagBits.get(23), flagBits.get(20), flagBits.get(21));
        builder.setFlags(flags);
        builder.setMonitoringId(buffer.readUnsignedInt());
        TlvsBuilder tbuilder = new TlvsBuilder();
        this.parseTlvs(tbuilder, buffer.slice());
        builder.setTlvs(tbuilder.build());
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Monitoring, "Wrong instance of PCEPObject. Passed %s. Needed MonitoringObject.", object.getClass());
        Monitoring monitoring = (Monitoring)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(1);
        Monitoring.Flags flags = monitoring.getFlags();
        BitArray flagBits = new BitArray(24);
        flagBits.set(19, flags.isIncomplete());
        flagBits.set(20, flags.isOverload());
        flagBits.set(21, flags.isProcessingTime());
        flagBits.set(22, flags.isGeneral());
        flagBits.set(23, flags.isLiveness());
        flagBits.toByteBuf(body);
        ByteBufWriteUtil.writeUnsignedInt(monitoring.getMonitoringId(), body);
        this.serializeTlvs(monitoring.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 19, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    @Override
    protected void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
    }
}

