/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.Svec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.SvecBuilder;

public class PCEPSvecObjectParser
implements ObjectParser,
ObjectSerializer {
    public static final int CLASS = 11;
    public static final int TYPE = 1;
    private static final int FLAGS_SIZE = 24;
    private static final int FLAGS_F_OFFSET = 1;
    private static final int S_FLAG_OFFSET = 21;
    private static final int N_FLAG_OFFSET = 22;
    private static final int L_FLAG_OFFSET = 23;
    private static final int MIN_SIZE = 4;

    @Override
    public Svec parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() < 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected: >=" + 4 + ".");
        }
        bytes.skipBytes(1);
        BitArray flags = BitArray.valueOf(bytes, 24);
        ArrayList<RequestId> requestIDs = Lists.newArrayList();
        while (bytes.isReadable()) {
            requestIDs.add(new RequestId(bytes.readUnsignedInt()));
        }
        if (requestIDs.isEmpty()) {
            throw new PCEPDeserializerException("Empty Svec Object - no request ids.");
        }
        SvecBuilder builder = new SvecBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        builder.setLinkDiverse(flags.get(23));
        builder.setNodeDiverse(flags.get(22));
        builder.setSrlgDiverse(flags.get(21));
        builder.setRequestsIds(requestIDs);
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Svec, "Wrong instance of PCEPObject. Passed %s. Needed SvecObject.", object.getClass());
        Svec svecObj = (Svec)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(1);
        BitArray flags = new BitArray(24);
        flags.set(23, svecObj.isLinkDiverse());
        flags.set(22, svecObj.isNodeDiverse());
        flags.set(21, svecObj.isSrlgDiverse());
        flags.toByteBuf(body);
        List<RequestId> requestIDs = svecObj.getRequestsIds();
        assert (!requestIDs.isEmpty()) : "Empty Svec Object - no request ids.";
        for (RequestId requestId : requestIDs) {
            ByteBufWriteUtil.writeUnsignedInt(requestId.getValue(), body);
        }
        ObjectUtil.formatSubobject(1, 11, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

