/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.parser.subobject.AsNumberCaseParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.EROSubobjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCase;

public class EROAsNumberSubobjectParser
implements EROSubobjectParser,
EROSubobjectSerializer {
    public static final int TYPE = 32;

    @Override
    public Subobject parseSubobject(ByteBuf buffer, boolean loose) throws PCEPDeserializerException {
        return new SubobjectBuilder().setLoose(loose).setSubobjectType(AsNumberCaseParser.parseSubobject(buffer)).build();
    }

    @Override
    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject.getSubobjectType() instanceof AsNumberCase, "Unknown subobject instance. Passed %s. Needed AsNumberCase.", subobject.getSubobjectType().getClass());
        ByteBuf body = AsNumberCaseParser.serializeSubobject((AsNumberCase)subobject.getSubobjectType());
        EROSubobjectUtil.formatSubobject(32, subobject.isLoose(), body, buffer);
    }
}

