/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.LabelParser;
import org.opendaylight.protocol.pcep.spi.LabelSerializer;
import org.opendaylight.protocol.pcep.spi.LabelUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.Type1LabelCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.Type1LabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.type1.label._case.Type1Label;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.type1.label._case.Type1LabelBuilder;

public class Type1LabelParser
implements LabelParser,
LabelSerializer {
    public static final int CTYPE = 1;
    public static final int LABEL_LENGTH = 4;

    @Override
    public LabelType parseLabel(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() != 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: " + 4 + ".");
        }
        return new Type1LabelCaseBuilder().setType1Label(new Type1LabelBuilder().setType1Label(buffer.readUnsignedInt()).build()).build();
    }

    @Override
    public void serializeLabel(boolean unidirectional, boolean global, LabelType subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject instanceof Type1LabelCase, "Unknown Label Subobject instance. Passed {}. Needed Type1LabelCase.", subobject.getClass());
        ByteBuf body = Unpooled.buffer(4);
        Type1Label type1Label = ((Type1LabelCase)subobject).getType1Label();
        Preconditions.checkArgument(type1Label != null, "Type1Label is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt(type1Label.getType1Label(), body);
        LabelUtil.formatLabel(1, unidirectional, global, body, buffer);
    }
}

