/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NoPathVectorTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.tlvs.NoPathVector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.tlvs.NoPathVectorBuilder;

public class NoPathVectorTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 1;
    private static final int FLAGS_SIZE = 32;
    private static final int REACHABLITY_PROBLEM = 24;
    private static final int NO_GCO_SOLUTION = 25;
    private static final int NO_GCO_MIGRATION_PATH = 26;
    private static final int PATH_KEY = 27;
    private static final int CHAIN_UNAVAILABLE = 28;
    private static final int UNKNOWN_SRC = 29;
    private static final int UNKNOWN_DEST = 30;
    private static final int PCE_UNAVAILABLE = 31;

    @Override
    public NoPathVector parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        if (buffer.readableBytes() != 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: >=" + 4 + ".");
        }
        BitArray flags = BitArray.valueOf(buffer, 32);
        return new NoPathVectorBuilder().setFlags(new NoPathVectorTlv.Flags(flags.get(28), flags.get(26), flags.get(25), flags.get(24), flags.get(27), flags.get(31), flags.get(30), flags.get(29))).build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof NoPathVector, "NoPathVectorTlv is mandatory.");
        NoPathVector noPath = (NoPathVector)tlv;
        ByteBuf body = Unpooled.buffer();
        BitArray flags = new BitArray(32);
        NoPathVectorTlv.Flags f = noPath.getFlags();
        flags.set(24, f.isP2mpUnreachable());
        flags.set(25, f.isNoGcoSolution());
        flags.set(26, f.isNoGcoMigration());
        flags.set(27, f.isPathKey());
        flags.set(28, f.isChainUnavailable());
        flags.set(29, f.isUnknownSource());
        flags.set(30, f.isUnknownDestination());
        flags.set(31, f.isPceUnavailable());
        flags.toByteBuf(body);
        TlvUtil.formatTlv(1, body, buffer);
    }
}

