/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.MessageParser;
import org.opendaylight.protocol.pcep.spi.MessageRegistry;
import org.opendaylight.protocol.pcep.spi.MessageSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleMessageRegistry
implements MessageRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMessageRegistry.class);
    private final HandlerRegistry<DataContainer, MessageParser, MessageSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerMessageParser(int messageType, MessageParser parser) {
        Preconditions.checkArgument(messageType >= 0 && messageType <= 255);
        return this.handlers.registerParser(messageType, parser);
    }

    public AutoCloseable registerMessageSerializer(Class<? extends Message> msgClass, MessageSerializer serializer) {
        return this.handlers.registerSerializer(msgClass, serializer);
    }

    @Override
    public Message parseMessage(int messageType, ByteBuf buffer, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument(messageType >= 0 && messageType <= 255);
        MessageParser parser = this.handlers.getParser(messageType);
        if (parser == null) {
            LOG.warn("PCEP parser for message type {} is not registered.", (Object)messageType);
            return null;
        }
        return parser.parseMessage(buffer, errors);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf buffer) {
        MessageSerializer serializer = this.handlers.getSerializer(message.getImplementedInterface());
        if (serializer == null) {
            LOG.warn("PCEP serializer for message type {} is not registered.", (Object)message.getClass());
            return;
        }
        serializer.serializeMessage(message, buffer);
    }
}

