/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.sync.optimizations;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.ietf.initiated00.CInitiated00LspObjectParser;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev171025.Tlvs1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev171025.Tlvs1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev171025.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.lsp.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;

public class SyncOptimizationsLspObjectParser
extends CInitiated00LspObjectParser {
    public SyncOptimizationsLspObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg);
    }

    @Override
    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            super.serializeTlvs(tlvs, body);
            this.serializeAugmentation(tlvs.getAugmentation(Tlvs1.class), body);
        }
    }

    private void serializeAugmentation(Tlvs1 tlv, ByteBuf body) {
        if (tlv != null) {
            this.serializeTlv(tlv.getLspDbVersion(), body);
        }
    }

    @Override
    public void addTlv(TlvsBuilder tbuilder, Tlv tlv) {
        Tlvs1 t;
        super.addTlv(tbuilder, tlv);
        Tlvs1Builder syncOptTlvsBuilder = new Tlvs1Builder();
        if (tbuilder.getAugmentation(Tlvs1.class) != null && (t = tbuilder.getAugmentation(Tlvs1.class)).getLspDbVersion() != null) {
            syncOptTlvsBuilder.setLspDbVersion(t.getLspDbVersion());
        }
        if (tlv instanceof LspDbVersion) {
            syncOptTlvsBuilder.setLspDbVersion((LspDbVersion)tlv);
        }
        tbuilder.addAugmentation(Tlvs1.class, syncOptTlvsBuilder.build());
    }
}

