/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Uninterruptibles;
import io.netty.util.concurrent.Future;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class CheckUtil {
    private static final int LATCH_TIMEOUT = 10;
    private static final int SLEEP_FOR = 200;
    private static final int TIMEOUT = 30;

    private CheckUtil() {
        throw new UnsupportedOperationException();
    }

    public static <T extends Future<?>> void waitFutureSuccess(T future) {
        CountDownLatch latch = new CountDownLatch(1);
        future.addListener(future1 -> latch.countDown());
        Uninterruptibles.awaitUninterruptibly(latch, 10L, TimeUnit.SECONDS);
        Verify.verify(future.isSuccess());
    }

    public static <R, T extends DataObject> R readDataOperational(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function) throws ReadFailedException {
        return CheckUtil.readDataOperational(dataBroker, iid, function, 30);
    }

    @VisibleForTesting
    static <R, T extends DataObject> R readDataOperational(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function, int timeout) throws ReadFailedException {
        return CheckUtil.readData(dataBroker, LogicalDatastoreType.OPERATIONAL, iid, function, timeout);
    }

    public static <R, T extends DataObject> R readDataConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function) throws ReadFailedException {
        return CheckUtil.readDataConfiguration(dataBroker, iid, function, 30);
    }

    @VisibleForTesting
    static <R, T extends DataObject> R readDataConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid, Function<T, R> function, int timeout) throws ReadFailedException {
        return CheckUtil.readData(dataBroker, LogicalDatastoreType.CONFIGURATION, iid, function, timeout);
    }

    private static <R, T extends DataObject> R readData(DataBroker dataBroker, LogicalDatastoreType ldt, InstanceIdentifier<T> iid, Function<T, R> function, int timeout) throws ReadFailedException {
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= (long)timeout) {
            ReadOnlyTransaction tx = dataBroker.newReadOnlyTransaction();
            Throwable throwable = null;
            try {
                R r;
                Optional<T> data = tx.read(ldt, iid).checkedGet();
                if (!data.isPresent()) continue;
                try {
                    r = function.apply(data.get());
                }
                catch (AssertionError e) {
                    try {
                        lastError = e;
                        Uninterruptibles.sleepUninterruptibly(200L, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
                return r;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                tx.close();
            }
        }
        throw lastError;
    }

    public static <T extends DataObject> T checkPresentOperational(DataBroker dataBroker, InstanceIdentifier<T> iid) throws ReadFailedException {
        return (T)CheckUtil.readData(dataBroker, LogicalDatastoreType.OPERATIONAL, iid, bgpRib -> bgpRib, 30);
    }

    public static <T extends DataObject> T checkPresentConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid) throws ReadFailedException {
        return (T)CheckUtil.readData(dataBroker, LogicalDatastoreType.CONFIGURATION, iid, bgpRib -> bgpRib, 30);
    }

    public static <T extends DataObject> void checkNotPresentOperational(DataBroker dataBroker, InstanceIdentifier<T> iid) throws ReadFailedException {
        CheckUtil.checkNotPresent(dataBroker, LogicalDatastoreType.OPERATIONAL, iid);
    }

    public static <T extends DataObject> void checkNotPresentConfiguration(DataBroker dataBroker, InstanceIdentifier<T> iid) throws ReadFailedException {
        CheckUtil.checkNotPresent(dataBroker, LogicalDatastoreType.CONFIGURATION, iid);
    }

    /*
     * Exception decompiling
     */
    private static <T extends DataObject> void checkNotPresent(DataBroker dataBroker, LogicalDatastoreType ldt, InstanceIdentifier<T> iid) throws ReadFailedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkEquals(CheckEquals function) throws Exception {
        CheckUtil.checkEquals(function, 30);
    }

    public static void checkEquals(CheckEquals function, int timeout) throws Exception {
        AssertionError lastError = null;
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= (long)timeout) {
            try {
                function.check();
                return;
            }
            catch (AssertionError e) {
                lastError = e;
                Uninterruptibles.sleepUninterruptibly(10L, TimeUnit.MILLISECONDS);
            }
        }
        throw lastError;
    }

    public static void checkReceivedMessages(ListenerCheck listener, int numberOfMessages) throws ReadFailedException {
        CheckUtil.checkReceivedMessages(listener, numberOfMessages, 30);
    }

    @VisibleForTesting
    static void checkReceivedMessages(ListenerCheck listener, int numberOfMessages, int timeout) throws ReadFailedException {
        Stopwatch sw = Stopwatch.createStarted();
        while (sw.elapsed(TimeUnit.SECONDS) <= (long)timeout) {
            if (listener.getListMessageSize() != numberOfMessages) {
                Uninterruptibles.sleepUninterruptibly(200L, TimeUnit.MILLISECONDS);
                continue;
            }
            return;
        }
        throw new AssertionError((Object)("Expected " + numberOfMessages + " but received " + listener.getListMessageSize()));
    }

    @FunctionalInterface
    public static interface CheckEquals {
        public void check() throws ExecutionException, InterruptedException;
    }

    public static interface ListenerCheck {
        public int getListMessageSize();
    }
}

