/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;

public final class InetSocketAddressUtil {
    private static final String SEPARATOR = ",";

    private InetSocketAddressUtil() {
        throw new UnsupportedOperationException();
    }

    public static List<InetSocketAddress> parseAddresses(String address, int defaultPort) {
        return Lists.transform(Arrays.asList(address.split(SEPARATOR)), input -> InetSocketAddressUtil.getInetSocketAddress(input, defaultPort));
    }

    public static List<InetSocketAddress> parseAddresses(String address) {
        return Lists.transform(Arrays.asList(address.split(SEPARATOR)), input -> InetSocketAddressUtil.getInetSocketAddress(input, null));
    }

    public static HostAndPort toHostAndPort(InetSocketAddress address) {
        return HostAndPort.fromParts(address.getHostString(), address.getPort());
    }

    public static InetSocketAddress getInetSocketAddress(String hostPortString, Integer defaultPort) {
        HostAndPort hostAndPort = HostAndPort.fromString(hostPortString);
        if (defaultPort != null) {
            return new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPortOrDefault(defaultPort));
        }
        return new InetSocketAddress(hostAndPort.getHost(), hostAndPort.getPort());
    }

    public static InetSocketAddress getRandomLoopbackInetSocketAddress(int port) {
        return new InetSocketAddress(InetSocketAddressUtil.getRandomLoopbackIpAddress(), port);
    }

    public static InetSocketAddress getRandomLoopbackInetSocketAddress() {
        return InetSocketAddressUtil.getRandomLoopbackInetSocketAddress(InetSocketAddressUtil.getRandomPort());
    }

    public static int getRandomPort() {
        return 20000 + (int)Math.round(40000.0 * Math.random());
    }

    public static String getRandomLoopbackIpAddress() {
        StringBuilder sb = new StringBuilder("127");
        for (int i = 0; i < 3; ++i) {
            sb.append(".").append(50 + (int)Math.round(Math.random() * 200.0));
        }
        return sb.toString();
    }
}

