/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715;

import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;

public class Counter64
implements Serializable {
    private static final long serialVersionUID = -1099590625836683370L;
    private final BigInteger _value;
    private static final Range<BigInteger>[] CHECK_VALUERANGE_RANGES;

    private static void check_valueRange(BigInteger value) {
        for (Range<BigInteger> r : CHECK_VALUERANGE_RANGES) {
            if (!r.contains(value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECK_VALUERANGE_RANGES)));
    }

    @ConstructorProperties(value={"value"})
    public Counter64(BigInteger _value) {
        if (_value != null) {
            Counter64.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public Counter64(Counter64 source) {
        this._value = source._value;
    }

    public static Counter64 getDefaultInstance(String defaultValue) {
        return new Counter64(new BigInteger(defaultValue));
    }

    public BigInteger getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Counter64 other = (Counter64)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Counter64.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed(BigInteger.ZERO, new BigInteger("18446744073709551615"));
        CHECK_VALUERANGE_RANGES = a;
    }
}

