/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.rfc2385.cfg.rev160324;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class Rfc2385Key
implements Serializable {
    private static final long serialVersionUID = 4716367644152991000L;
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.length();
        if (length >= 1 && length <= 80) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[1..80]].", value));
    }

    @ConstructorProperties(value={"value"})
    public Rfc2385Key(String _value) {
        if (_value != null) {
            Rfc2385Key.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public Rfc2385Key(Rfc2385Key source) {
        this._value = source._value;
    }

    public static Rfc2385Key getDefaultInstance(String defaultValue) {
        return new Rfc2385Key(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rfc2385Key other = (Rfc2385Key)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Rfc2385Key.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

