/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class SrpIdNumber
implements Serializable {
    private static final long serialVersionUID = -7985654367172602048L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFEL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967294]].", value));
    }

    @ConstructorProperties(value={"value"})
    public SrpIdNumber(Long _value) {
        if (_value != null) {
            SrpIdNumber.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public SrpIdNumber(SrpIdNumber source) {
        this._value = source._value;
    }

    public static SrpIdNumber getDefaultInstance(String defaultValue) {
        return new SrpIdNumber(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SrpIdNumber other = (SrpIdNumber)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(SrpIdNumber.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

