/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.LspIdentifiers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.lsp.identifiers.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspIdentifiersBuilder
implements Builder<LspIdentifiers> {
    private AddressFamily _addressFamily;
    private LspId _lspId;
    private TunnelId _tunnelId;
    Map<Class<? extends Augmentation<LspIdentifiers>>, Augmentation<LspIdentifiers>> augmentation = Collections.emptyMap();

    public LspIdentifiersBuilder() {
    }

    public LspIdentifiersBuilder(LspIdentifiers base) {
        AugmentationHolder casted;
        this._addressFamily = base.getAddressFamily();
        this._lspId = base.getLspId();
        this._tunnelId = base.getTunnelId();
        if (base instanceof LspIdentifiersImpl) {
            LspIdentifiersImpl impl = (LspIdentifiersImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LspIdentifiers>>, Augmentation<LspIdentifiers>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public AddressFamily getAddressFamily() {
        return this._addressFamily;
    }

    public LspId getLspId() {
        return this._lspId;
    }

    public TunnelId getTunnelId() {
        return this._tunnelId;
    }

    public <E extends Augmentation<LspIdentifiers>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LspIdentifiersBuilder setAddressFamily(AddressFamily value) {
        this._addressFamily = value;
        return this;
    }

    public LspIdentifiersBuilder setLspId(LspId value) {
        this._lspId = value;
        return this;
    }

    public LspIdentifiersBuilder setTunnelId(TunnelId value) {
        this._tunnelId = value;
        return this;
    }

    public LspIdentifiersBuilder addAugmentation(Class<? extends Augmentation<LspIdentifiers>> augmentationType, Augmentation<LspIdentifiers> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LspIdentifiers>>, Augmentation<LspIdentifiers>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LspIdentifiersBuilder removeAugmentation(Class<? extends Augmentation<LspIdentifiers>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public LspIdentifiers build() {
        return new LspIdentifiersImpl(this);
    }

    private static final class LspIdentifiersImpl
    implements LspIdentifiers {
        private final AddressFamily _addressFamily;
        private final LspId _lspId;
        private final TunnelId _tunnelId;
        private Map<Class<? extends Augmentation<LspIdentifiers>>, Augmentation<LspIdentifiers>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LspIdentifiers> getImplementedInterface() {
            return LspIdentifiers.class;
        }

        private LspIdentifiersImpl(LspIdentifiersBuilder base) {
            this._addressFamily = base.getAddressFamily();
            this._lspId = base.getLspId();
            this._tunnelId = base.getTunnelId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LspIdentifiers>>, Augmentation<LspIdentifiers>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LspIdentifiers>>, Augmentation<LspIdentifiers>>(base.augmentation);
                }
            }
        }

        @Override
        public AddressFamily getAddressFamily() {
            return this._addressFamily;
        }

        @Override
        public LspId getLspId() {
            return this._lspId;
        }

        @Override
        public TunnelId getTunnelId() {
            return this._tunnelId;
        }

        @Override
        public <E extends Augmentation<LspIdentifiers>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._addressFamily);
            result = 31 * result + Objects.hashCode(this._lspId);
            result = 31 * result + Objects.hashCode(this._tunnelId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LspIdentifiers.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LspIdentifiers other = (LspIdentifiers)obj;
            if (!Objects.equals(this._addressFamily, other.getAddressFamily())) {
                return false;
            }
            if (!Objects.equals(this._lspId, other.getLspId())) {
                return false;
            }
            if (!Objects.equals(this._tunnelId, other.getTunnelId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspIdentifiersImpl otherImpl = (LspIdentifiersImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LspIdentifiers>>, Augmentation<LspIdentifiers>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "LspIdentifiers [";
            StringBuilder builder = new StringBuilder(name);
            if (this._addressFamily != null) {
                builder.append("_addressFamily=");
                builder.append(this._addressFamily);
                builder.append(", ");
            }
            if (this._lspId != null) {
                builder.append("_lspId=");
                builder.append(this._lspId);
                builder.append(", ");
            }
            if (this._tunnelId != null) {
                builder.append("_tunnelId=");
                builder.append(this._tunnelId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

