/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.OperationalStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.PlspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspBuilder
implements Builder<Lsp> {
    private OperationalStatus _operational;
    private PlspId _plspId;
    private Tlvs _tlvs;
    private Boolean _administrative;
    private Boolean _delegate;
    private Boolean _ignore;
    private Boolean _processingRule;
    private Boolean _remove;
    private Boolean _sync;
    Map<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>> augmentation = Collections.emptyMap();

    public LspBuilder() {
    }

    public LspBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LspBuilder(Lsp base) {
        AugmentationHolder casted;
        this._operational = base.getOperational();
        this._plspId = base.getPlspId();
        this._tlvs = base.getTlvs();
        this._administrative = base.isAdministrative();
        this._delegate = base.isDelegate();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        this._remove = base.isRemove();
        this._sync = base.isSync();
        if (base instanceof LspImpl) {
            LspImpl impl = (LspImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public OperationalStatus getOperational() {
        return this._operational;
    }

    public PlspId getPlspId() {
        return this._plspId;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isAdministrative() {
        return this._administrative;
    }

    public Boolean isDelegate() {
        return this._delegate;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isRemove() {
        return this._remove;
    }

    public Boolean isSync() {
        return this._sync;
    }

    public <E extends Augmentation<Lsp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LspBuilder setOperational(OperationalStatus value) {
        this._operational = value;
        return this;
    }

    public LspBuilder setPlspId(PlspId value) {
        this._plspId = value;
        return this;
    }

    public LspBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public LspBuilder setAdministrative(Boolean value) {
        this._administrative = value;
        return this;
    }

    public LspBuilder setDelegate(Boolean value) {
        this._delegate = value;
        return this;
    }

    public LspBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public LspBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public LspBuilder setRemove(Boolean value) {
        this._remove = value;
        return this;
    }

    public LspBuilder setSync(Boolean value) {
        this._sync = value;
        return this;
    }

    public LspBuilder addAugmentation(Class<? extends Augmentation<Lsp>> augmentationType, Augmentation<Lsp> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LspBuilder removeAugmentation(Class<? extends Augmentation<Lsp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Lsp build() {
        return new LspImpl(this);
    }

    private static final class LspImpl
    implements Lsp {
        private final OperationalStatus _operational;
        private final PlspId _plspId;
        private final Tlvs _tlvs;
        private final Boolean _administrative;
        private final Boolean _delegate;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private final Boolean _remove;
        private final Boolean _sync;
        private Map<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Lsp> getImplementedInterface() {
            return Lsp.class;
        }

        private LspImpl(LspBuilder base) {
            this._operational = base.getOperational();
            this._plspId = base.getPlspId();
            this._tlvs = base.getTlvs();
            this._administrative = base.isAdministrative();
            this._delegate = base.isDelegate();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            this._remove = base.isRemove();
            this._sync = base.isSync();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>>(base.augmentation);
                }
            }
        }

        @Override
        public OperationalStatus getOperational() {
            return this._operational;
        }

        @Override
        public PlspId getPlspId() {
            return this._plspId;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isAdministrative() {
            return this._administrative;
        }

        @Override
        public Boolean isDelegate() {
            return this._delegate;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isRemove() {
            return this._remove;
        }

        @Override
        public Boolean isSync() {
            return this._sync;
        }

        @Override
        public <E extends Augmentation<Lsp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._operational);
            result = 31 * result + Objects.hashCode(this._plspId);
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._administrative);
            result = 31 * result + Objects.hashCode(this._delegate);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            result = 31 * result + Objects.hashCode(this._remove);
            result = 31 * result + Objects.hashCode(this._sync);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Lsp.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Lsp other = (Lsp)obj;
            if (!Objects.equals((Object)this._operational, (Object)other.getOperational())) {
                return false;
            }
            if (!Objects.equals(this._plspId, other.getPlspId())) {
                return false;
            }
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._administrative, other.isAdministrative())) {
                return false;
            }
            if (!Objects.equals(this._delegate, other.isDelegate())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (!Objects.equals(this._remove, other.isRemove())) {
                return false;
            }
            if (!Objects.equals(this._sync, other.isSync())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspImpl otherImpl = (LspImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Lsp>>, Augmentation<Lsp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Lsp [";
            StringBuilder builder = new StringBuilder(name);
            if (this._operational != null) {
                builder.append("_operational=");
                builder.append((Object)this._operational);
                builder.append(", ");
            }
            if (this._plspId != null) {
                builder.append("_plspId=");
                builder.append(this._plspId);
                builder.append(", ");
            }
            if (this._tlvs != null) {
                builder.append("_tlvs=");
                builder.append(this._tlvs);
                builder.append(", ");
            }
            if (this._administrative != null) {
                builder.append("_administrative=");
                builder.append(this._administrative);
                builder.append(", ");
            }
            if (this._delegate != null) {
                builder.append("_delegate=");
                builder.append(this._delegate);
                builder.append(", ");
            }
            if (this._ignore != null) {
                builder.append("_ignore=");
                builder.append(this._ignore);
                builder.append(", ");
            }
            if (this._processingRule != null) {
                builder.append("_processingRule=");
                builder.append(this._processingRule);
                builder.append(", ");
            }
            if (this._remove != null) {
                builder.append("_remove=");
                builder.append(this._remove);
                builder.append(", ");
            }
            if (this._sync != null) {
                builder.append("_sync=");
                builder.append(this._sync);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

