/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.ReplyTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ReplyTimeBuilder
implements Builder<ReplyTime> {
    private Long _averageTime;
    private Long _maxTime;
    private Long _minTime;
    Map<Class<? extends Augmentation<ReplyTime>>, Augmentation<ReplyTime>> augmentation = Collections.emptyMap();

    public ReplyTimeBuilder() {
    }

    public ReplyTimeBuilder(ReplyTime base) {
        AugmentationHolder casted;
        this._averageTime = base.getAverageTime();
        this._maxTime = base.getMaxTime();
        this._minTime = base.getMinTime();
        if (base instanceof ReplyTimeImpl) {
            ReplyTimeImpl impl = (ReplyTimeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ReplyTime>>, Augmentation<ReplyTime>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public Long getAverageTime() {
        return this._averageTime;
    }

    public Long getMaxTime() {
        return this._maxTime;
    }

    public Long getMinTime() {
        return this._minTime;
    }

    public <E extends Augmentation<ReplyTime>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkAverageTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ReplyTimeBuilder setAverageTime(Long value) {
        if (value != null) {
            ReplyTimeBuilder.checkAverageTimeRange(value);
        }
        this._averageTime = value;
        return this;
    }

    private static void checkMaxTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ReplyTimeBuilder setMaxTime(Long value) {
        if (value != null) {
            ReplyTimeBuilder.checkMaxTimeRange(value);
        }
        this._maxTime = value;
        return this;
    }

    private static void checkMinTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ReplyTimeBuilder setMinTime(Long value) {
        if (value != null) {
            ReplyTimeBuilder.checkMinTimeRange(value);
        }
        this._minTime = value;
        return this;
    }

    public ReplyTimeBuilder addAugmentation(Class<? extends Augmentation<ReplyTime>> augmentationType, Augmentation<ReplyTime> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReplyTime>>, Augmentation<ReplyTime>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ReplyTimeBuilder removeAugmentation(Class<? extends Augmentation<ReplyTime>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ReplyTime build() {
        return new ReplyTimeImpl(this);
    }

    private static final class ReplyTimeImpl
    implements ReplyTime {
        private final Long _averageTime;
        private final Long _maxTime;
        private final Long _minTime;
        private Map<Class<? extends Augmentation<ReplyTime>>, Augmentation<ReplyTime>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ReplyTime> getImplementedInterface() {
            return ReplyTime.class;
        }

        private ReplyTimeImpl(ReplyTimeBuilder base) {
            this._averageTime = base.getAverageTime();
            this._maxTime = base.getMaxTime();
            this._minTime = base.getMinTime();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ReplyTime>>, Augmentation<ReplyTime>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ReplyTime>>, Augmentation<ReplyTime>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getAverageTime() {
            return this._averageTime;
        }

        @Override
        public Long getMaxTime() {
            return this._maxTime;
        }

        @Override
        public Long getMinTime() {
            return this._minTime;
        }

        @Override
        public <E extends Augmentation<ReplyTime>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._averageTime);
            result = 31 * result + Objects.hashCode(this._maxTime);
            result = 31 * result + Objects.hashCode(this._minTime);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ReplyTime.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ReplyTime other = (ReplyTime)obj;
            if (!Objects.equals(this._averageTime, other.getAverageTime())) {
                return false;
            }
            if (!Objects.equals(this._maxTime, other.getMaxTime())) {
                return false;
            }
            if (!Objects.equals(this._minTime, other.getMinTime())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ReplyTimeImpl otherImpl = (ReplyTimeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ReplyTime>>, Augmentation<ReplyTime>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ReplyTime [";
            StringBuilder builder = new StringBuilder(name);
            if (this._averageTime != null) {
                builder.append("_averageTime=");
                builder.append(this._averageTime);
                builder.append(", ");
            }
            if (this._maxTime != null) {
                builder.append("_maxTime=");
                builder.append(this._maxTime);
                builder.append(", ");
            }
            if (this._minTime != null) {
                builder.append("_minTime=");
                builder.append(this._minTime);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

