/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;

public class ProtocolVersion
implements Serializable {
    private static final long serialVersionUID = -7283574556842814269L;
    private final Short _value;

    private static void check_valueRange(short value) {
        if (value >= 1 && value <= 7) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..7]].", value));
    }

    @ConstructorProperties(value={"value"})
    public ProtocolVersion(Short _value) {
        if (_value != null) {
            ProtocolVersion.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public ProtocolVersion(ProtocolVersion source) {
        this._value = source._value;
    }

    public static ProtocolVersion getDefaultInstance(String defaultValue) {
        return new ProtocolVersion(Short.valueOf(defaultValue));
    }

    public Short getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolVersion other = (ProtocolVersion)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(ProtocolVersion.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

