/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;

public class Ipv4ExtendedTunnelId
extends Ipv4Address
implements Serializable {
    private static final long serialVersionUID = -3621789471093465557L;
    private static final Pattern[] patterns;
    public static final List<String> PATTERN_CONSTANTS;

    @ConstructorProperties(value={"value"})
    public Ipv4ExtendedTunnelId(String _value) {
        super(_value);
        Objects.requireNonNull(_value, "Supplied value may not be null");
        for (Pattern p : patterns) {
            Preconditions.checkArgument(p.matcher(_value).matches(), "Supplied value \"%s\" does not match required pattern \"%s\"", (Object)_value, (Object)p);
        }
    }

    public Ipv4ExtendedTunnelId(Ipv4ExtendedTunnelId source) {
        super(source);
    }

    public Ipv4ExtendedTunnelId(Ipv4Address source) {
        super(source);
    }

    public static Ipv4ExtendedTunnelId getDefaultInstance(String defaultValue) {
        return new Ipv4ExtendedTunnelId(defaultValue);
    }

    static {
        PATTERN_CONSTANTS = ImmutableList.of("^(?:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?)$");
        Pattern[] a = new Pattern[PATTERN_CONSTANTS.size()];
        int i = 0;
        for (String regEx : PATTERN_CONSTANTS) {
            a[i++] = Pattern.compile(regEx);
        }
        patterns = a;
    }
}

