/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum LinkFlags {
    TotallyUnprotected(0, "totally-unprotected"),
    ExtraTraffic(1, "extra-traffic"),
    Unprotected(2, "unprotected"),
    Shared(4, "shared"),
    Dedicated1to1(8, "dedicated-1to1"),
    Dedicated1plus1(10, "dedicated-1plus1"),
    Enhanced(20, "enhanced");

    private static final Map<Integer, LinkFlags> VALUE_MAP;
    private final String name;
    private final int value;

    private LinkFlags(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static LinkFlags forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder<Integer, LinkFlags> b = ImmutableMap.builder();
        for (LinkFlags enumItem : LinkFlags.values()) {
            b.put(enumItem.value, enumItem);
        }
        VALUE_MAP = b.build();
    }
}

