/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TspecObjectBuilder
implements Builder<TspecObject> {
    private Long _maximumPacketSize;
    private Long _minimumPolicedUnit;
    private Float32 _peakDataRate;
    private Float32 _tokenBucketRate;
    private Float32 _tokenBucketSize;
    Map<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> augmentation = Collections.emptyMap();

    public TspecObjectBuilder() {
    }

    public TspecObjectBuilder(TspecObject base) {
        AugmentationHolder casted;
        this._maximumPacketSize = base.getMaximumPacketSize();
        this._minimumPolicedUnit = base.getMinimumPolicedUnit();
        this._peakDataRate = base.getPeakDataRate();
        this._tokenBucketRate = base.getTokenBucketRate();
        this._tokenBucketSize = base.getTokenBucketSize();
        if (base instanceof TspecObjectImpl) {
            TspecObjectImpl impl = (TspecObjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public Long getMaximumPacketSize() {
        return this._maximumPacketSize;
    }

    public Long getMinimumPolicedUnit() {
        return this._minimumPolicedUnit;
    }

    public Float32 getPeakDataRate() {
        return this._peakDataRate;
    }

    public Float32 getTokenBucketRate() {
        return this._tokenBucketRate;
    }

    public Float32 getTokenBucketSize() {
        return this._tokenBucketSize;
    }

    public <E extends Augmentation<TspecObject>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaximumPacketSizeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public TspecObjectBuilder setMaximumPacketSize(Long value) {
        if (value != null) {
            TspecObjectBuilder.checkMaximumPacketSizeRange(value);
        }
        this._maximumPacketSize = value;
        return this;
    }

    private static void checkMinimumPolicedUnitRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public TspecObjectBuilder setMinimumPolicedUnit(Long value) {
        if (value != null) {
            TspecObjectBuilder.checkMinimumPolicedUnitRange(value);
        }
        this._minimumPolicedUnit = value;
        return this;
    }

    public TspecObjectBuilder setPeakDataRate(Float32 value) {
        this._peakDataRate = value;
        return this;
    }

    public TspecObjectBuilder setTokenBucketRate(Float32 value) {
        this._tokenBucketRate = value;
        return this;
    }

    public TspecObjectBuilder setTokenBucketSize(Float32 value) {
        this._tokenBucketSize = value;
        return this;
    }

    public TspecObjectBuilder addAugmentation(Class<? extends Augmentation<TspecObject>> augmentationType, Augmentation<TspecObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TspecObjectBuilder removeAugmentation(Class<? extends Augmentation<TspecObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public TspecObject build() {
        return new TspecObjectImpl(this);
    }

    private static final class TspecObjectImpl
    implements TspecObject {
        private final Long _maximumPacketSize;
        private final Long _minimumPolicedUnit;
        private final Float32 _peakDataRate;
        private final Float32 _tokenBucketRate;
        private final Float32 _tokenBucketSize;
        private Map<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<TspecObject> getImplementedInterface() {
            return TspecObject.class;
        }

        private TspecObjectImpl(TspecObjectBuilder base) {
            this._maximumPacketSize = base.getMaximumPacketSize();
            this._minimumPolicedUnit = base.getMinimumPolicedUnit();
            this._peakDataRate = base.getPeakDataRate();
            this._tokenBucketRate = base.getTokenBucketRate();
            this._tokenBucketSize = base.getTokenBucketSize();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getMaximumPacketSize() {
            return this._maximumPacketSize;
        }

        @Override
        public Long getMinimumPolicedUnit() {
            return this._minimumPolicedUnit;
        }

        @Override
        public Float32 getPeakDataRate() {
            return this._peakDataRate;
        }

        @Override
        public Float32 getTokenBucketRate() {
            return this._tokenBucketRate;
        }

        @Override
        public Float32 getTokenBucketSize() {
            return this._tokenBucketSize;
        }

        @Override
        public <E extends Augmentation<TspecObject>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maximumPacketSize);
            result = 31 * result + Objects.hashCode(this._minimumPolicedUnit);
            result = 31 * result + Objects.hashCode(this._peakDataRate);
            result = 31 * result + Objects.hashCode(this._tokenBucketRate);
            result = 31 * result + Objects.hashCode(this._tokenBucketSize);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TspecObject.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TspecObject other = (TspecObject)obj;
            if (!Objects.equals(this._maximumPacketSize, other.getMaximumPacketSize())) {
                return false;
            }
            if (!Objects.equals(this._minimumPolicedUnit, other.getMinimumPolicedUnit())) {
                return false;
            }
            if (!Objects.equals(this._peakDataRate, other.getPeakDataRate())) {
                return false;
            }
            if (!Objects.equals(this._tokenBucketRate, other.getTokenBucketRate())) {
                return false;
            }
            if (!Objects.equals(this._tokenBucketSize, other.getTokenBucketSize())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TspecObjectImpl otherImpl = (TspecObjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "TspecObject [";
            StringBuilder builder = new StringBuilder(name);
            if (this._maximumPacketSize != null) {
                builder.append("_maximumPacketSize=");
                builder.append(this._maximumPacketSize);
                builder.append(", ");
            }
            if (this._minimumPolicedUnit != null) {
                builder.append("_minimumPolicedUnit=");
                builder.append(this._minimumPolicedUnit);
                builder.append(", ");
            }
            if (this._peakDataRate != null) {
                builder.append("_peakDataRate=");
                builder.append(this._peakDataRate);
                builder.append(", ");
            }
            if (this._tokenBucketRate != null) {
                builder.append("_tokenBucketRate=");
                builder.append(this._tokenBucketRate);
                builder.append(", ");
            }
            if (this._tokenBucketSize != null) {
                builder.append("_tokenBucketSize=");
                builder.append(this._tokenBucketSize);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

