/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.LinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.LinkId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.link.attributes.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.link.attributes.Source;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.link.attributes.SupportingLink;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.LinkKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LinkBuilder
implements Builder<Link> {
    private Destination _destination;
    private LinkKey _key;
    private LinkId _linkId;
    private Source _source;
    private List<SupportingLink> _supportingLink;
    Map<Class<? extends Augmentation<Link>>, Augmentation<Link>> augmentation = Collections.emptyMap();

    public LinkBuilder() {
    }

    public LinkBuilder(LinkAttributes arg) {
        this._linkId = arg.getLinkId();
        this._source = arg.getSource();
        this._destination = arg.getDestination();
        this._supportingLink = arg.getSupportingLink();
    }

    public LinkBuilder(Link base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new LinkKey(base.getLinkId());
            this._linkId = base.getLinkId();
        } else {
            this._key = base.getKey();
            this._linkId = this._key.getLinkId();
        }
        this._destination = base.getDestination();
        this._source = base.getSource();
        this._supportingLink = base.getSupportingLink();
        if (base instanceof LinkImpl) {
            LinkImpl impl = (LinkImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LinkAttributes) {
            this._linkId = ((LinkAttributes)arg).getLinkId();
            this._source = ((LinkAttributes)arg).getSource();
            this._destination = ((LinkAttributes)arg).getDestination();
            this._supportingLink = ((LinkAttributes)arg).getSupportingLink();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.LinkAttributes] \nbut was: " + arg);
        }
    }

    public Destination getDestination() {
        return this._destination;
    }

    public LinkKey getKey() {
        return this._key;
    }

    public LinkId getLinkId() {
        return this._linkId;
    }

    public Source getSource() {
        return this._source;
    }

    public List<SupportingLink> getSupportingLink() {
        return this._supportingLink;
    }

    public <E extends Augmentation<Link>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LinkBuilder setDestination(Destination value) {
        this._destination = value;
        return this;
    }

    public LinkBuilder setKey(LinkKey value) {
        this._key = value;
        return this;
    }

    public LinkBuilder setLinkId(LinkId value) {
        this._linkId = value;
        return this;
    }

    public LinkBuilder setSource(Source value) {
        this._source = value;
        return this;
    }

    public LinkBuilder setSupportingLink(List<SupportingLink> value) {
        this._supportingLink = value;
        return this;
    }

    public LinkBuilder addAugmentation(Class<? extends Augmentation<Link>> augmentationType, Augmentation<Link> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LinkBuilder removeAugmentation(Class<? extends Augmentation<Link>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Link build() {
        return new LinkImpl(this);
    }

    private static final class LinkImpl
    implements Link {
        private final Destination _destination;
        private final LinkKey _key;
        private final LinkId _linkId;
        private final Source _source;
        private final List<SupportingLink> _supportingLink;
        private Map<Class<? extends Augmentation<Link>>, Augmentation<Link>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Link> getImplementedInterface() {
            return Link.class;
        }

        private LinkImpl(LinkBuilder base) {
            if (base.getKey() == null) {
                this._key = new LinkKey(base.getLinkId());
                this._linkId = base.getLinkId();
            } else {
                this._key = base.getKey();
                this._linkId = this._key.getLinkId();
            }
            this._destination = base.getDestination();
            this._source = base.getSource();
            this._supportingLink = base.getSupportingLink();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Link>>, Augmentation<Link>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Link>>, Augmentation<Link>>(base.augmentation);
                }
            }
        }

        @Override
        public Destination getDestination() {
            return this._destination;
        }

        @Override
        public LinkKey getKey() {
            return this._key;
        }

        @Override
        public LinkId getLinkId() {
            return this._linkId;
        }

        @Override
        public Source getSource() {
            return this._source;
        }

        @Override
        public List<SupportingLink> getSupportingLink() {
            return this._supportingLink;
        }

        @Override
        public <E extends Augmentation<Link>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destination);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._linkId);
            result = 31 * result + Objects.hashCode(this._source);
            result = 31 * result + Objects.hashCode(this._supportingLink);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Link.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Link other = (Link)obj;
            if (!Objects.equals(this._destination, other.getDestination())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._linkId, other.getLinkId())) {
                return false;
            }
            if (!Objects.equals(this._source, other.getSource())) {
                return false;
            }
            if (!Objects.equals(this._supportingLink, other.getSupportingLink())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LinkImpl otherImpl = (LinkImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Link>>, Augmentation<Link>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Link [";
            StringBuilder builder = new StringBuilder(name);
            if (this._destination != null) {
                builder.append("_destination=");
                builder.append(this._destination);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._linkId != null) {
                builder.append("_linkId=");
                builder.append(this._linkId);
                builder.append(", ");
            }
            if (this._source != null) {
                builder.append("_source=");
                builder.append(this._source);
                builder.append(", ");
            }
            if (this._supportingLink != null) {
                builder.append("_supportingLink=");
                builder.append(this._supportingLink);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

