/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPoint;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNode;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeBuilder
implements Builder<Node> {
    private NodeKey _key;
    private NodeId _nodeId;
    private List<SupportingNode> _supportingNode;
    private List<TerminationPoint> _terminationPoint;
    Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = Collections.emptyMap();

    public NodeBuilder() {
    }

    public NodeBuilder(NodeAttributes arg) {
        this._nodeId = arg.getNodeId();
        this._supportingNode = arg.getSupportingNode();
    }

    public NodeBuilder(Node base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new NodeKey(base.getNodeId());
            this._nodeId = base.getNodeId();
        } else {
            this._key = base.getKey();
            this._nodeId = this._key.getNodeId();
        }
        this._supportingNode = base.getSupportingNode();
        this._terminationPoint = base.getTerminationPoint();
        if (base instanceof NodeImpl) {
            NodeImpl impl = (NodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeAttributes) {
            this._nodeId = ((NodeAttributes)arg).getNodeId();
            this._supportingNode = ((NodeAttributes)arg).getSupportingNode();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeAttributes] \nbut was: " + arg);
        }
    }

    public NodeKey getKey() {
        return this._key;
    }

    public NodeId getNodeId() {
        return this._nodeId;
    }

    public List<SupportingNode> getSupportingNode() {
        return this._supportingNode;
    }

    public List<TerminationPoint> getTerminationPoint() {
        return this._terminationPoint;
    }

    public <E extends Augmentation<Node>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NodeBuilder setKey(NodeKey value) {
        this._key = value;
        return this;
    }

    public NodeBuilder setNodeId(NodeId value) {
        this._nodeId = value;
        return this;
    }

    public NodeBuilder setSupportingNode(List<SupportingNode> value) {
        this._supportingNode = value;
        return this;
    }

    public NodeBuilder setTerminationPoint(List<TerminationPoint> value) {
        this._terminationPoint = value;
        return this;
    }

    public NodeBuilder addAugmentation(Class<? extends Augmentation<Node>> augmentationType, Augmentation<Node> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodeBuilder removeAugmentation(Class<? extends Augmentation<Node>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Node build() {
        return new NodeImpl(this);
    }

    private static final class NodeImpl
    implements Node {
        private final NodeKey _key;
        private final NodeId _nodeId;
        private final List<SupportingNode> _supportingNode;
        private final List<TerminationPoint> _terminationPoint;
        private Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Node> getImplementedInterface() {
            return Node.class;
        }

        private NodeImpl(NodeBuilder base) {
            if (base.getKey() == null) {
                this._key = new NodeKey(base.getNodeId());
                this._nodeId = base.getNodeId();
            } else {
                this._key = base.getKey();
                this._nodeId = this._key.getNodeId();
            }
            this._supportingNode = base.getSupportingNode();
            this._terminationPoint = base.getTerminationPoint();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Node>>, Augmentation<Node>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(base.augmentation);
                }
            }
        }

        @Override
        public NodeKey getKey() {
            return this._key;
        }

        @Override
        public NodeId getNodeId() {
            return this._nodeId;
        }

        @Override
        public List<SupportingNode> getSupportingNode() {
            return this._supportingNode;
        }

        @Override
        public List<TerminationPoint> getTerminationPoint() {
            return this._terminationPoint;
        }

        @Override
        public <E extends Augmentation<Node>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._nodeId);
            result = 31 * result + Objects.hashCode(this._supportingNode);
            result = 31 * result + Objects.hashCode(this._terminationPoint);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Node.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Node other = (Node)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._nodeId, other.getNodeId())) {
                return false;
            }
            if (!Objects.equals(this._supportingNode, other.getSupportingNode())) {
                return false;
            }
            if (!Objects.equals(this._terminationPoint, other.getTerminationPoint())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeImpl otherImpl = (NodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Node>>, Augmentation<Node>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Node [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._nodeId != null) {
                builder.append("_nodeId=");
                builder.append(this._nodeId);
                builder.append(", ");
            }
            if (this._supportingNode != null) {
                builder.append("_supportingNode=");
                builder.append(this._supportingNode);
                builder.append(", ");
            }
            if (this._terminationPoint != null) {
                builder.append("_terminationPoint=");
                builder.append(this._terminationPoint);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

