/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.opendaylight.yangtools.triemap.EntryNode;
import org.opendaylight.yangtools.triemap.EntryUtil;
import org.opendaylight.yangtools.triemap.ImmutableTrieMap;
import org.opendaylight.yangtools.triemap.MainNode;
import org.opendaylight.yangtools.triemap.SNode;

final class TNode<K, V>
extends MainNode<K, V>
implements EntryNode<K, V> {
    final K key;
    final V value;
    final int hc;

    TNode(K key, V value, int hc) {
        this.key = key;
        this.value = value;
        this.hc = hc;
    }

    TNode<K, V> copy() {
        return new TNode<K, V>(this.key, this.value, this.hc);
    }

    TNode<K, V> copyTombed() {
        return new TNode<K, V>(this.key, this.value, this.hc);
    }

    SNode<K, V> copyUntombed() {
        return new SNode<K, V>(this.key, this.value, this.hc);
    }

    @Override
    int trySize() {
        return 1;
    }

    @Override
    int size(ImmutableTrieMap<?, ?> ct) {
        return 1;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return EntryUtil.hash(this.key, this.value);
    }

    @Override
    @SuppressFBWarnings(value={"EQ_UNUSUAL"}, justification="Equality handled by utility methods")
    public boolean equals(Object obj) {
        return EntryUtil.equal(obj, this.key, this.value);
    }

    public String toString() {
        return EntryUtil.string(this.key, this.value);
    }
}

