/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.triemap.MutableTrieMap;
import org.opendaylight.yangtools.triemap.TrieMap;
import org.opendaylight.yangtools.util.ReadOnlyTrieMap;
import org.opendaylight.yangtools.util.ReadWriteTrieMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapAdaptor {
    public static final int DEFAULT_COPY_MAX_ITEMS = 100;
    public static final String COPY_MAX_ITEMS_MAX_PROP = "org.opendaylight.yangtools.util.mapadaptor.maxcopy";
    public static final int DEFAULT_PERSIST_MIN_ITEMS = 50;
    public static final String PERSIST_MIN_ITEMS_PROP = "org.opendaylight.yangtools.util.mapadaptor.minpersist";
    private static final Logger LOG = LoggerFactory.getLogger(MapAdaptor.class);
    private static final MapAdaptor DEFAULT_INSTANCE = new MapAdaptor(true, MapAdaptor.getProperty("org.opendaylight.yangtools.util.mapadaptor.maxcopy", 100), MapAdaptor.getProperty("org.opendaylight.yangtools.util.mapadaptor.minpersist", 50));
    private final boolean useSingleton;
    private final int persistMinItems;
    private final int copyMaxItems;

    private static int getProperty(String name, int defaultValue) {
        int val = Integer.getInteger(name, defaultValue);
        if (val > 0) {
            return val;
        }
        LOG.warn("Ignoring illegal value of {}: has to be a positive number", (Object)name);
        return defaultValue;
    }

    private MapAdaptor(boolean useSingleton, int copyMaxItems, int persistMinItems) {
        this.useSingleton = useSingleton;
        this.copyMaxItems = copyMaxItems;
        this.persistMinItems = persistMinItems;
    }

    public static MapAdaptor getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static MapAdaptor getInstance(boolean useSingleton, int copyMaxItems, int persistMinItems) {
        Preconditions.checkArgument(copyMaxItems >= 0, "copyMaxItems has to be a non-negative integer");
        Preconditions.checkArgument(persistMinItems >= 0, "persistMinItems has to be a positive integer");
        Preconditions.checkArgument(persistMinItems <= copyMaxItems, "persistMinItems must be less than or equal to copyMaxItems");
        return new MapAdaptor(useSingleton, copyMaxItems, persistMinItems);
    }

    public <K, V> Map<K, V> initialSnapshot(int expectedSize) {
        Preconditions.checkArgument(expectedSize >= 0);
        if (expectedSize > this.persistMinItems) {
            return new ReadWriteTrieMap();
        }
        if (expectedSize < 2) {
            return new HashMap(1);
        }
        if (expectedSize == 2) {
            return new HashMap(2);
        }
        return Maps.newHashMapWithExpectedSize(expectedSize);
    }

    public <K, V> Map<K, V> takeSnapshot(Map<K, V> input) {
        Map<K, V> ret;
        if (input instanceof ReadOnlyTrieMap) {
            return ((ReadOnlyTrieMap)input).toReadWrite();
        }
        LOG.trace("Converting input {} to a HashMap", (Object)input);
        int size = input.size();
        if (size <= 6) {
            int target;
            switch (size) {
                case 0: 
                case 1: {
                    target = 1;
                    break;
                }
                case 2: {
                    target = 2;
                    break;
                }
                case 3: {
                    target = 4;
                    break;
                }
                default: {
                    target = 8;
                }
            }
            ret = new HashMap(target);
            ret.putAll(input);
        } else if (input instanceof HashMap) {
            Map tmp = (Map)((HashMap)input).clone();
            ret = tmp;
        } else {
            ret = new HashMap<K, V>(input);
        }
        LOG.trace("Read-write HashMap is {}", (Object)ret);
        return ret;
    }

    public <K, V> Map<K, V> optimize(Map<K, V> input) {
        int size;
        if (input instanceof ReadOnlyTrieMap) {
            LOG.warn("Optimizing read-only map {}", (Object)input);
        }
        if ((size = input.size()) == 0) {
            LOG.trace("Reducing input {} to an empty map", (Object)input);
            return ImmutableMap.of();
        }
        if (input instanceof ReadWriteTrieMap && size >= this.persistMinItems) {
            return ((ReadWriteTrieMap)input).toReadOnly();
        }
        if (this.useSingleton && size == 1) {
            Map.Entry<K, V> e = input.entrySet().iterator().next();
            Map<K, V> ret = Collections.singletonMap(e.getKey(), e.getValue());
            LOG.trace("Reducing input {} to singleton map {}", (Object)input, (Object)ret);
            return ret;
        }
        if (size <= this.copyMaxItems) {
            if (input instanceof HashMap) {
                return input;
            }
            LOG.trace("Copying input {} to a HashMap ({} entries)", (Object)input, (Object)size);
            HashMap<K, V> ret = new HashMap<K, V>(input);
            LOG.trace("Read-only HashMap is {}", (Object)ret);
            return ret;
        }
        LOG.trace("Copying input {} to a TrieMap ({} entries)", (Object)input, (Object)size);
        MutableTrieMap<K, V> map = TrieMap.create();
        map.putAll(input);
        ReadOnlyTrieMap ret = new ReadOnlyTrieMap(map, size);
        LOG.trace("Read-only TrieMap is {}", (Object)ret);
        return ret;
    }

    static {
        LOG.debug("Configured HashMap/TrieMap cutoff at {}/{} entries", (Object)MapAdaptor.DEFAULT_INSTANCE.persistMinItems, (Object)MapAdaptor.DEFAULT_INSTANCE.copyMaxItems);
    }
}

