/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.ModifiableMapPhase;
import org.opendaylight.yangtools.util.OffsetMapCache;
import org.opendaylight.yangtools.util.SharedSingletonMap;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;

@Beta
public abstract class MutableOffsetMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
ModifiableMapPhase<K, V> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Object REMOVED = new Object();
    private final Map<K, Integer> offsets;
    private HashMap<K, V> newKeys;
    private Object[] objects;
    private int removed = 0;
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"})
    private volatile transient int modCount;
    private boolean needClone = true;

    MutableOffsetMap(Map<K, Integer> offsets, V[] objects, HashMap<K, V> newKeys) {
        Verify.verify(newKeys.isEmpty());
        this.offsets = Objects.requireNonNull(offsets);
        this.objects = Objects.requireNonNull(objects);
        this.newKeys = Objects.requireNonNull(newKeys);
    }

    MutableOffsetMap(HashMap<K, V> newKeys) {
        this(ImmutableMap.of(), EMPTY_ARRAY, newKeys);
    }

    MutableOffsetMap(Map<K, Integer> offsets, Map<K, V> source, HashMap<K, V> newKeys) {
        this(offsets, new Object[offsets.size()], newKeys);
        for (Map.Entry<K, V> e : source.entrySet()) {
            this.objects[offsets.get(e.getKey()).intValue()] = Objects.requireNonNull(e.getValue());
        }
        this.needClone = false;
    }

    public static <K, V> MutableOffsetMap<K, V> orderedCopyOf(Map<K, V> map) {
        if (map instanceof Ordered) {
            return ((Ordered)map).clone();
        }
        if (map instanceof ImmutableOffsetMap) {
            ImmutableOffsetMap om = (ImmutableOffsetMap)map;
            return new Ordered(om.offsets(), om.objects());
        }
        return new Ordered<K, V>(map);
    }

    public static <K, V> MutableOffsetMap<K, V> unorderedCopyOf(Map<K, V> map) {
        if (map instanceof Unordered) {
            return ((Unordered)map).clone();
        }
        if (map instanceof ImmutableOffsetMap) {
            ImmutableOffsetMap om = (ImmutableOffsetMap)map;
            return new Unordered(om.offsets(), om.objects());
        }
        return new Unordered<K, V>(map);
    }

    public static <K, V> MutableOffsetMap<K, V> ordered() {
        return new Ordered();
    }

    public static <K, V> MutableOffsetMap<K, V> unordered() {
        return new Unordered();
    }

    abstract Object removedObject();

    abstract UnmodifiableMapPhase<K, V> modifiedMap(List<K> var1, V[] var2);

    abstract UnmodifiableMapPhase<K, V> unmodifiedMap(Map<K, Integer> var1, V[] var2);

    abstract SharedSingletonMap<K, V> singletonMap();

    @Override
    public final int size() {
        return this.offsets.size() + this.newKeys.size() - this.removed;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsKey(Object key) {
        Object obj;
        Integer offset = this.offsets.get(key);
        if (offset != null && !REMOVED.equals(obj = this.objects[offset])) {
            return obj != null;
        }
        return this.newKeys.containsKey(key);
    }

    @Override
    public final V get(Object key) {
        Object obj;
        Integer offset = this.offsets.get(key);
        if (offset != null && !REMOVED.equals(obj = this.objects[offset])) {
            Object ret = obj;
            return (V)ret;
        }
        return this.newKeys.get(key);
    }

    private void cloneArray() {
        if (this.needClone) {
            this.needClone = false;
            if (this.objects.length != 0) {
                this.objects = (Object[])this.objects.clone();
            }
        }
    }

    @Override
    public final V put(K key, V value) {
        Object obj;
        Objects.requireNonNull(value);
        Integer offset = this.offsets.get(Objects.requireNonNull(key));
        if (offset != null && !REMOVED.equals(obj = this.objects[offset])) {
            Object ret = obj;
            this.cloneArray();
            this.objects[offset.intValue()] = value;
            if (ret == null) {
                ++this.modCount;
                --this.removed;
            }
            return (V)ret;
        }
        V ret = this.newKeys.put(key, value);
        if (ret == null) {
            ++this.modCount;
        }
        return ret;
    }

    @Override
    public final V remove(Object key) {
        Object obj;
        Integer offset = this.offsets.get(key);
        if (offset != null && !REMOVED.equals(obj = this.objects[offset])) {
            this.cloneArray();
            Object ret = obj;
            this.objects[offset.intValue()] = this.removedObject();
            if (ret != null) {
                ++this.modCount;
                ++this.removed;
            }
            return (V)ret;
        }
        V ret = this.newKeys.remove(key);
        if (ret != null) {
            ++this.modCount;
        }
        return ret;
    }

    @Override
    public final void clear() {
        if (this.size() != 0) {
            this.newKeys.clear();
            this.cloneArray();
            Arrays.fill(this.objects, this.removedObject());
            this.removed = this.objects.length;
            ++this.modCount;
        }
    }

    @Override
    @Nonnull
    public final Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    @Nonnull
    public Map<K, V> toUnmodifiableMap() {
        if (this.removed == 0 && this.newKeys.isEmpty()) {
            this.needClone = true;
            Object[] values = this.objects;
            return this.unmodifiedMap(this.offsets, values);
        }
        int s = this.size();
        if (s == 0) {
            return ImmutableMap.of();
        }
        if (s == 1) {
            return this.singletonMap();
        }
        ArrayList<K> keyset = new ArrayList<K>(s);
        if (this.removed != 0) {
            if (this.removed != this.offsets.size()) {
                for (Map.Entry<K, Integer> e : this.offsets.entrySet()) {
                    Object o = this.objects[e.getValue()];
                    if (o == null || REMOVED.equals(o)) continue;
                    keyset.add(e.getKey());
                }
            }
        } else {
            keyset.addAll(this.offsets.keySet());
        }
        keyset.addAll(this.newKeys.keySet());
        Object[] values = new Object[keyset.size()];
        int offset = 0;
        if (this.removed != 0) {
            if (this.removed != this.offsets.size()) {
                for (Map.Entry<K, Integer> e : this.offsets.entrySet()) {
                    Object o = this.objects[e.getValue()];
                    if (o == null || REMOVED.equals(o)) continue;
                    Object v = o;
                    values[offset++] = v;
                }
            }
        } else {
            System.arraycopy(this.objects, 0, values, 0, this.offsets.size());
            offset = this.offsets.size();
        }
        for (Map.Entry<K, Integer> v : this.newKeys.values()) {
            values[offset++] = v;
        }
        return this.modifiedMap(keyset, values);
    }

    @Override
    public MutableOffsetMap<K, V> clone() {
        MutableOffsetMap ret;
        try {
            ret = (MutableOffsetMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone is expected to work", e);
        }
        ret.newKeys = (HashMap)this.newKeys.clone();
        ret.needClone = true;
        return ret;
    }

    @Override
    public final int hashCode() {
        int result = 0;
        for (Map.Entry<K, Integer> e : this.offsets.entrySet()) {
            Object v = this.objects[e.getValue()];
            if (v == null) continue;
            result += e.getKey().hashCode() ^ v.hashCode();
        }
        return result + this.newKeys.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        Map om;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        if (obj instanceof ImmutableOffsetMap) {
            om = (ImmutableOffsetMap)obj;
            if (this.newKeys.isEmpty() && this.offsets.equals(((ImmutableOffsetMap)om).offsets())) {
                return Arrays.deepEquals(this.objects, ((ImmutableOffsetMap)om).objects());
            }
        } else if (obj instanceof MutableOffsetMap) {
            om = (MutableOffsetMap)obj;
            if (this.offsets.equals(((MutableOffsetMap)om).offsets)) {
                return Arrays.deepEquals(this.objects, ((MutableOffsetMap)om).objects) && this.newKeys.equals(((MutableOffsetMap)om).newKeys);
            }
        }
        Map other = (Map)obj;
        if (this.size() != other.size() || !this.keySet().equals(other.keySet())) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.newKeys.entrySet()) {
                if (entry.getValue().equals(other.get(entry.getKey()))) continue;
                return false;
            }
            for (Map.Entry<K, Object> entry : this.offsets.entrySet()) {
                Object val = this.objects[(Integer)entry.getValue()];
                if (val == null || REMOVED.equals(val) || val.equals(other.get(entry.getKey()))) continue;
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public final Set<K> keySet() {
        return new KeySet();
    }

    @VisibleForTesting
    final boolean needClone() {
        return this.needClone;
    }

    @VisibleForTesting
    final Object array() {
        return this.objects;
    }

    @VisibleForTesting
    final Object newKeys() {
        return this.newKeys;
    }

    private abstract class AbstractSetIterator<E>
    implements Iterator<E> {
        private final Iterator<Map.Entry<K, Integer>> oldIterator;
        private final Iterator<K> newIterator;
        private int expectedModCount;
        private K currentKey;
        private K nextKey;

        AbstractSetIterator() {
            this.oldIterator = MutableOffsetMap.this.offsets.entrySet().iterator();
            this.newIterator = MutableOffsetMap.this.newKeys.keySet().iterator();
            this.expectedModCount = MutableOffsetMap.this.modCount;
            this.updateNextKey();
        }

        private void updateNextKey() {
            while (this.oldIterator.hasNext()) {
                Map.Entry e = this.oldIterator.next();
                Object obj = MutableOffsetMap.this.objects[e.getValue()];
                if (obj == null || REMOVED.equals(obj)) continue;
                this.nextKey = e.getKey();
                return;
            }
            this.nextKey = this.newIterator.hasNext() ? this.newIterator.next() : null;
        }

        private void checkModCount() {
            if (MutableOffsetMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public final boolean hasNext() {
            this.checkModCount();
            return this.nextKey != null;
        }

        @Override
        public final void remove() {
            Objects.requireNonNull(this.currentKey != null);
            this.checkModCount();
            Integer offset = (Integer)MutableOffsetMap.this.offsets.get(this.currentKey);
            if (offset != null) {
                MutableOffsetMap.this.cloneArray();
                ((MutableOffsetMap)MutableOffsetMap.this).objects[offset.intValue()] = MutableOffsetMap.this.removedObject();
                MutableOffsetMap.this.removed++;
            } else {
                this.newIterator.remove();
            }
            this.expectedModCount = ++MutableOffsetMap.this.modCount;
            this.currentKey = null;
        }

        protected final K nextKey() {
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            this.checkModCount();
            this.currentKey = this.nextKey;
            this.updateNextKey();
            return this.currentKey;
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        @Nonnull
        public Iterator<K> iterator() {
            return new AbstractSetIterator<K>(){

                @Override
                public K next() {
                    return this.nextKey();
                }
            };
        }

        @Override
        public int size() {
            return MutableOffsetMap.this.size();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new AbstractSetIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    Object key = this.nextKey();
                    return new AbstractMap.SimpleEntry(key, MutableOffsetMap.this.get(key));
                }
            };
        }

        @Override
        public int size() {
            return MutableOffsetMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getValue() == null) {
                return false;
            }
            return e.getValue().equals(MutableOffsetMap.this.get(e.getKey()));
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            Object p;
            Object v = Objects.requireNonNull(e.getValue());
            return !v.equals(p = MutableOffsetMap.this.put(e.getKey(), v));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getValue() == null) {
                return false;
            }
            Object v = MutableOffsetMap.this.get(e.getKey());
            if (e.getValue().equals(v)) {
                MutableOffsetMap.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            MutableOffsetMap.this.clear();
        }
    }

    static final class Unordered<K, V>
    extends MutableOffsetMap<K, V> {
        Unordered() {
            super(new HashMap());
        }

        Unordered(Map<K, V> source) {
            super(OffsetMapCache.unorderedOffsets(source.keySet()), source, new HashMap());
        }

        Unordered(Map<K, Integer> offsets, V[] objects) {
            super(offsets, objects, new HashMap());
        }

        @Override
        Object removedObject() {
            return null;
        }

        @Override
        UnmodifiableMapPhase<K, V> modifiedMap(List<K> keys, V[] values) {
            Map<K, Integer> offsets = OffsetMapCache.unorderedOffsets(keys);
            return new ImmutableOffsetMap.Unordered<K, V>(offsets, OffsetMapCache.adjustedArray(offsets, keys, values));
        }

        @Override
        UnmodifiableMapPhase<K, V> unmodifiedMap(Map<K, Integer> offsetMap, V[] values) {
            return new ImmutableOffsetMap.Unordered<K, V>(offsetMap, values);
        }

        @Override
        SharedSingletonMap<K, V> singletonMap() {
            return SharedSingletonMap.unorderedCopyOf(this);
        }
    }

    static final class Ordered<K, V>
    extends MutableOffsetMap<K, V> {
        Ordered() {
            super(new LinkedHashMap());
        }

        Ordered(Map<K, V> source) {
            super(OffsetMapCache.orderedOffsets(source.keySet()), source, new LinkedHashMap());
        }

        Ordered(Map<K, Integer> offsets, V[] objects) {
            super(offsets, objects, new LinkedHashMap());
        }

        @Override
        Object removedObject() {
            return REMOVED;
        }

        @Override
        UnmodifiableMapPhase<K, V> modifiedMap(List<K> keys, V[] values) {
            return new ImmutableOffsetMap.Ordered<K, V>(OffsetMapCache.orderedOffsets(keys), values);
        }

        @Override
        UnmodifiableMapPhase<K, V> unmodifiedMap(Map<K, Integer> offsetMap, V[] values) {
            return new ImmutableOffsetMap.Ordered<K, V>(offsetMap, values);
        }

        @Override
        SharedSingletonMap<K, V> singletonMap() {
            return SharedSingletonMap.orderedCopyOf(this);
        }
    }
}

