/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.concepts.Immutable;

@Beta
public abstract class SingletonSet<E>
implements Set<E>,
Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final SingletonSet<?> NULL_SINGLETON = new SingletonSet<Object>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean contains(Object o) {
            return o == null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public Object getElement() {
            return null;
        }

        public String toString() {
            return "[null]";
        }

        private Object readResolve() {
            return NULL_SINGLETON;
        }
    };

    public static <E> SingletonSet<E> of(@Nonnull E element) {
        if (element == null) {
            return NULL_SINGLETON;
        }
        return new RegularSingletonSet<E>(element);
    }

    public abstract E getElement();

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final Iterator<E> iterator() {
        return Iterators.singletonIterator(this.getElement());
    }

    @Override
    @Nonnull
    public final Object[] toArray() {
        return new Object[]{this.getElement()};
    }

    @Override
    @Nonnull
    public final <T> T[] toArray(@Nonnull T[] a) {
        if (a.length > 0) {
            a[0] = this.getElement();
            return a;
        }
        return new Object[]{this.getElement()};
    }

    @Override
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean containsAll(@Nonnull Collection<?> c) {
        if (c.isEmpty()) {
            return true;
        }
        if (c.size() != 1) {
            return false;
        }
        return this.otherContains(c);
    }

    @Override
    public final boolean addAll(@Nonnull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract int hashCode();

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set s = (Set)obj;
        return s.size() == 1 && this.otherContains(s);
    }

    private boolean otherContains(Collection<?> other) {
        try {
            return other.contains(this.getElement());
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    private static final class RegularSingletonSet<E>
    extends SingletonSet<E> {
        private static final long serialVersionUID = 1L;
        private final E element;

        RegularSingletonSet(E element) {
            this.element = Objects.requireNonNull(element);
        }

        @Override
        public boolean contains(Object o) {
            return this.element.equals(o);
        }

        @Override
        public E getElement() {
            return this.element;
        }

        @Override
        public int hashCode() {
            return this.getElement().hashCode();
        }

        public String toString() {
            return "[" + this.element + ']';
        }
    }
}

