/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.AbstractListeningExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.util.concurrent.AsyncNotifyingListenableFutureTask;

public class AsyncNotifyingListeningExecutorService
extends AbstractListeningExecutorService {
    private final ExecutorService delegate;
    private final Executor listenableFutureExecutor;

    public AsyncNotifyingListeningExecutorService(ExecutorService delegate, @Nullable Executor listenableFutureExecutor) {
        this.delegate = Objects.requireNonNull(delegate);
        this.listenableFutureExecutor = listenableFutureExecutor;
    }

    private <T> AsyncNotifyingListenableFutureTask<T> newFutureTask(Callable<T> task) {
        return AsyncNotifyingListenableFutureTask.create(task, this.listenableFutureExecutor);
    }

    private <T> AsyncNotifyingListenableFutureTask<T> newFutureTask(Runnable task, T result) {
        return AsyncNotifyingListenableFutureTask.create(task, result, this.listenableFutureExecutor);
    }

    protected ExecutorService getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean awaitTermination(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    @Nonnull
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        this.delegate.execute(command);
    }

    @Override
    @Nonnull
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        AsyncNotifyingListenableFutureTask<T> futureTask = this.newFutureTask(task);
        this.delegate.execute(futureTask);
        return futureTask;
    }

    @Override
    @Nonnull
    public ListenableFuture<?> submit(Runnable task) {
        AsyncNotifyingListenableFutureTask<Object> futureTask = this.newFutureTask(task, null);
        this.delegate.execute(futureTask);
        return futureTask;
    }

    @Override
    @Nonnull
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        AsyncNotifyingListenableFutureTask<T> futureTask = this.newFutureTask(task, result);
        this.delegate.execute(futureTask);
        return futureTask;
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(this).add("delegate", this.delegate)).toString();
    }
}

