/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AugmentationFieldGetter {
    private static final Logger LOG = LoggerFactory.getLogger(AugmentationFieldGetter.class);
    private static final AugmentationFieldGetter DUMMY = new AugmentationFieldGetter(){

        @Override
        protected Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAugmentations(Object input) {
            return Collections.emptyMap();
        }
    };
    private static final AugmentationFieldGetter AUGMENTATION_HOLDER_GETTER = new AugmentationFieldGetter(){

        @Override
        protected Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAugmentations(Object input) {
            return ((AugmentationHolder)input).augmentations();
        }
    };
    private static final LoadingCache<Class<?>, AugmentationFieldGetter> AUGMENTATION_GETTERS = CacheBuilder.newBuilder().weakKeys().build(new AugmentationGetterLoader());

    AugmentationFieldGetter() {
    }

    protected abstract Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAugmentations(Object var1);

    public static AugmentationFieldGetter getGetter(Class<? extends Object> clz) {
        if (AugmentationHolder.class.isAssignableFrom(clz)) {
            return AUGMENTATION_HOLDER_GETTER;
        }
        return AUGMENTATION_GETTERS.getUnchecked(clz);
    }

    private static final class ReflectionAugmentationFieldGetter
    extends AugmentationFieldGetter {
        private final MethodHandle fieldGetter;

        ReflectionAugmentationFieldGetter(MethodHandle mh) {
            this.fieldGetter = Preconditions.checkNotNull(mh);
        }

        @Override
        protected Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAugmentations(Object input) {
            try {
                return this.fieldGetter.invokeExact(input);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Failed to access augmentation field on " + input, e);
            }
        }
    }

    private static final class AugmentationGetterLoader
    extends CacheLoader<Class<?>, AugmentationFieldGetter> {
        private static final MethodType GETTER_TYPE = MethodType.methodType(Map.class, Object.class);
        private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

        private AugmentationGetterLoader() {
        }

        @Override
        public AugmentationFieldGetter load(Class<?> key) throws IllegalAccessException {
            Field field;
            try {
                field = key.getDeclaredField("augmentation");
                field.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException e) {
                LOG.warn("Failed to acquire augmentation field {}, ignoring augmentations in class {}", "augmentation", key, e);
                return DUMMY;
            }
            if (!Map.class.isAssignableFrom(field.getType())) {
                LOG.warn("Class {} field {} is not a Map, ignoring augmentations", (Object)key, (Object)"augmentation");
                return DUMMY;
            }
            return new ReflectionAugmentationFieldGetter(LOOKUP.unreflectGetter(field).asType(GETTER_TYPE));
        }
    }
}

