/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.BindingMapping;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.AbstractMappedRpcInvoker;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.binding.util.RpcServiceInvoker;
import org.opendaylight.yangtools.yang.common.QName;

final class ClassBasedRpcServiceInvoker
extends AbstractMappedRpcInvoker<String> {
    private static final LoadingCache<Class<? extends RpcService>, RpcServiceInvoker> INVOKERS = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<? extends RpcService>, RpcServiceInvoker>(){

        @Override
        public RpcServiceInvoker load(Class<? extends RpcService> key) {
            HashMap<String, Method> ret = new HashMap<String, Method>();
            for (Method m : key.getMethods()) {
                ret.put(m.getName(), m);
            }
            return new ClassBasedRpcServiceInvoker((Map<String, Method>)ret);
        }
    });

    ClassBasedRpcServiceInvoker(Map<String, Method> ret) {
        super(ret);
    }

    @Override
    protected String qnameToKey(QName qname) {
        return BindingMapping.getMethodName(qname);
    }

    static RpcServiceInvoker instanceFor(Class<? extends RpcService> type) {
        Preconditions.checkArgument(type.isInterface());
        Preconditions.checkArgument(BindingReflections.isBindingClass(type));
        return INVOKERS.getUnchecked(type);
    }
}

