/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class StringValueObjectFactory<T> {
    private static final MethodType CONSTRUCTOR_METHOD_TYPE = MethodType.methodType(Object.class, Object.class);
    private static final MethodType SETTER_METHOD_TYPE = MethodType.methodType(Void.TYPE, Object.class, String.class);
    private static final Logger LOG = LoggerFactory.getLogger(StringValueObjectFactory.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final MethodHandle constructor;
    private final MethodHandle setter;
    private final T template;

    private StringValueObjectFactory(T template, MethodHandle constructor, MethodHandle setter) {
        this.template = Preconditions.checkNotNull(template);
        this.constructor = constructor.bindTo(template);
        this.setter = Preconditions.checkNotNull(setter);
    }

    public static <T> StringValueObjectFactory<T> create(Class<T> clazz, String templateString) {
        StringValueObjectFactory<T> ret;
        Field f;
        Constructor<T> copyConstructor;
        T template;
        Constructor<T> stringConstructor;
        try {
            stringConstructor = clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("%s does not have a String constructor", clazz), e);
        }
        try {
            template = stringConstructor.newInstance(templateString);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Failed to instantiate template %s for '%s'", clazz, templateString), e);
        }
        try {
            copyConstructor = clazz.getConstructor(clazz);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("%s does not have a copy constructor", clazz), e);
        }
        try {
            f = clazz.getDeclaredField("_value");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("%s does not have required internal field", clazz), e);
        }
        f.setAccessible(true);
        try {
            ret = new StringValueObjectFactory<T>(template, LOOKUP.unreflectConstructor(copyConstructor).asType(CONSTRUCTOR_METHOD_TYPE), LOOKUP.unreflectSetter(f).asType(SETTER_METHOD_TYPE));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to instantiate method handles", e);
        }
        Throwable t = new Throwable("Invocation stack");
        t.fillInStackTrace();
        if (StringValueObjectFactory.matchesPackage(clazz.getPackage().getName(), t.getStackTrace())) {
            LOG.info("Instantiated factory for {}", (Object)clazz);
        } else {
            LOG.warn("Instantiated factory for {} outside its package", (Object)clazz, (Object)t);
        }
        return ret;
    }

    private static boolean matchesPackage(String pkg, StackTraceElement[] stackTrace) {
        for (StackTraceElement e : stackTrace) {
            String sp = e.getClassName();
            if (!sp.startsWith(pkg) || sp.lastIndexOf(46) != pkg.length()) continue;
            return true;
        }
        return false;
    }

    public T newInstance(String string) {
        Preconditions.checkNotNull(string, "Argument may not be null");
        try {
            Object ret = this.constructor.invokeExact();
            this.setter.invokeExact(ret, string);
            LOG.trace("Instantiated new object {} value {}", (Object)ret.getClass(), (Object)string);
            return (T)ret;
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }

    public T getTemplate() {
        return this.template;
    }
}

