/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.FixedYangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class YangInstanceIdentifierBuilder
implements YangInstanceIdentifier.InstanceIdentifierBuilder {
    private final HashCodeBuilder<YangInstanceIdentifier.PathArgument> hash;
    private final List<YangInstanceIdentifier.PathArgument> path;

    YangInstanceIdentifierBuilder() {
        this.hash = new HashCodeBuilder();
        this.path = new ArrayList<YangInstanceIdentifier.PathArgument>();
    }

    YangInstanceIdentifierBuilder(List<YangInstanceIdentifier.PathArgument> prefix, int hash) {
        this.path = new ArrayList<YangInstanceIdentifier.PathArgument>(prefix);
        this.hash = new HashCodeBuilder(hash);
    }

    private YangInstanceIdentifier.InstanceIdentifierBuilder addArgument(YangInstanceIdentifier.PathArgument arg) {
        this.path.add(arg);
        this.hash.addArgument(arg);
        return this;
    }

    @Override
    public YangInstanceIdentifier.InstanceIdentifierBuilder node(YangInstanceIdentifier.PathArgument arg) {
        return this.addArgument(Objects.requireNonNull(arg));
    }

    @Override
    public YangInstanceIdentifier.InstanceIdentifierBuilder node(QName nodeType) {
        return this.addArgument(new YangInstanceIdentifier.NodeIdentifier(nodeType));
    }

    @Override
    public YangInstanceIdentifier.InstanceIdentifierBuilder append(Collection<? extends YangInstanceIdentifier.PathArgument> args) {
        this.path.addAll(args);
        args.forEach(this.hash::addArgument);
        return this;
    }

    @Override
    public YangInstanceIdentifier.InstanceIdentifierBuilder nodeWithKey(QName nodeType, QName key, Object value) {
        return this.addArgument(new YangInstanceIdentifier.NodeIdentifierWithPredicates(nodeType, key, value));
    }

    @Override
    public YangInstanceIdentifier.InstanceIdentifierBuilder nodeWithKey(QName nodeType, Map<QName, Object> keyValues) {
        return this.addArgument(new YangInstanceIdentifier.NodeIdentifierWithPredicates(nodeType, keyValues));
    }

    @Override
    public YangInstanceIdentifier build() {
        return FixedYangInstanceIdentifier.create(this.path, this.hash.build());
    }
}

