/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;

final class NormalizedNodeDataTreeCandidateNode
implements DataTreeCandidateNode {
    private final NormalizedNode<?, ?> data;

    NormalizedNodeDataTreeCandidateNode(@Nonnull NormalizedNode<?, ?> data) {
        this.data = Objects.requireNonNull(data);
    }

    @Override
    @Nonnull
    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.data.getIdentifier();
    }

    @Override
    @Nonnull
    public Collection<DataTreeCandidateNode> getChildNodes() {
        if (this.data instanceof NormalizedNodeContainer) {
            return Collections2.transform(((NormalizedNodeContainer)this.data).getValue(), input -> input == null ? null : new NormalizedNodeDataTreeCandidateNode((NormalizedNode<?, ?>)input));
        }
        return ImmutableList.of();
    }

    @Override
    public DataTreeCandidateNode getModifiedChild(YangInstanceIdentifier.PathArgument childIdentifier) {
        if (this.data instanceof NormalizedNodeContainer) {
            Optional child = ((NormalizedNodeContainer)this.data).getChild(childIdentifier);
            return child.map(input -> new NormalizedNodeDataTreeCandidateNode((NormalizedNode<?, ?>)input)).orElse(null);
        }
        return null;
    }

    @Override
    @Nonnull
    public ModificationType getModificationType() {
        return ModificationType.WRITE;
    }

    @Override
    @Nonnull
    public Optional<NormalizedNode<?, ?>> getDataAfter() {
        return Optional.of(this.data);
    }

    @Override
    @Nonnull
    public Optional<NormalizedNode<?, ?>> getDataBefore() {
        return Optional.empty();
    }
}

