/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.type;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public enum ModifierKind {
    INVERT_MATCH("invert-match");

    private static final Map<String, ModifierKind> MODIFIER_KIND_MAP;
    private final String keyword;

    private ModifierKind(String keyword) {
        this.keyword = Objects.requireNonNull(keyword);
    }

    @Nonnull
    public String getKeyword() {
        return this.keyword;
    }

    public static Optional<ModifierKind> parse(String keyword) {
        return Optional.ofNullable(MODIFIER_KIND_MAP.get(Objects.requireNonNull(keyword)));
    }

    static {
        MODIFIER_KIND_MAP = Maps.uniqueIndex(Arrays.asList(ModifierKind.values()), ModifierKind::getKeyword);
    }
}

