/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangNames;
import org.opendaylight.yangtools.yang.model.repo.api.ResourceYinTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YinSchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.YinTextFileSchemaSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class YinTextSchemaSource
extends ByteSource
implements YinSchemaSourceRepresentation {
    private static final Logger LOG = LoggerFactory.getLogger(YinTextSchemaSource.class);
    private static final String XML_EXTENSION = ".xml";
    private final SourceIdentifier identifier;

    protected YinTextSchemaSource(SourceIdentifier identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public static SourceIdentifier identifierFromFilename(String name) {
        String baseName;
        if (name.endsWith(".yin")) {
            baseName = name.substring(0, name.length() - ".yin".length());
        } else if (name.endsWith(XML_EXTENSION)) {
            LOG.warn("XML file {} being loaded as YIN", (Object)name);
            baseName = name.substring(0, name.length() - XML_EXTENSION.length());
        } else {
            throw new IllegalArgumentException("Filename " + name + " does not have a .yin or .xml extension");
        }
        Map.Entry<String, String> parsed = YangNames.parseFilename(baseName);
        return RevisionSourceIdentifier.create(parsed.getKey(), Revision.ofNullable(parsed.getValue()));
    }

    @Override
    public final SourceIdentifier getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public Class<? extends YinTextSchemaSource> getType() {
        return YinTextSchemaSource.class;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(this).add("identifier", this.identifier)).toString();
    }

    protected abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);

    public static YinTextSchemaSource delegateForByteSource(SourceIdentifier identifier, ByteSource delegate) {
        return new DelegatedYinTextSchemaSource(identifier, delegate);
    }

    public static YinTextSchemaSource forFile(File file) {
        Preconditions.checkArgument(file.isFile(), "Supplied file %s is not a file", (Object)file);
        return new YinTextFileSchemaSource(YinTextSchemaSource.identifierFromFilename(file.getName()), file);
    }

    public static YinTextSchemaSource forResource(Class<?> clazz, String resourceName) {
        String fileName = resourceName.substring(resourceName.lastIndexOf(47) + 1);
        SourceIdentifier identifier = YinTextSchemaSource.identifierFromFilename(fileName);
        URL url = Resources.getResource(clazz, resourceName);
        return new ResourceYinTextSchemaSource(identifier, url);
    }

    private static final class DelegatedYinTextSchemaSource
    extends YinTextSchemaSource
    implements Delegator<ByteSource> {
        private final ByteSource delegate;

        private DelegatedYinTextSchemaSource(SourceIdentifier identifier, ByteSource delegate) {
            super(identifier);
            this.delegate = Objects.requireNonNull(delegate);
        }

        @Override
        public ByteSource getDelegate() {
            return this.delegate;
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.delegate.openStream();
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return toStringHelper.add("delegate", this.delegate);
        }
    }
}

