/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.parser.object.PCEPOpenObjectParser;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.Tlvs1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.Tlvs1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.stateful.capability.tlv.Stateful;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.TlvsBuilder;

public class Stateful07OpenObjectParser
extends PCEPOpenObjectParser {
    public Stateful07OpenObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg);
    }

    @Override
    public void addTlv(TlvsBuilder tbuilder, Tlv tlv) {
        Tlvs1 t;
        super.addTlv(tbuilder, tlv);
        Tlvs1Builder statefulBuilder = new Tlvs1Builder();
        if (tbuilder.getAugmentation(Tlvs1.class) != null && (t = tbuilder.getAugmentation(Tlvs1.class)).getStateful() != null) {
            statefulBuilder.setStateful(t.getStateful());
        }
        if (tlv instanceof Stateful) {
            statefulBuilder.setStateful((Stateful)tlv);
        }
        tbuilder.addAugmentation(Tlvs1.class, statefulBuilder.build());
    }

    @Override
    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        Tlvs1 statefulTlvs;
        if (tlvs == null) {
            return;
        }
        super.serializeTlvs(tlvs, body);
        if (tlvs.getOfList() != null) {
            this.serializeTlv(tlvs.getOfList(), body);
        }
        if (tlvs.getAugmentation(Tlvs1.class) != null && (statefulTlvs = tlvs.getAugmentation(Tlvs1.class)).getStateful() != null) {
            this.serializeTlv(statefulTlvs.getStateful(), body);
        }
    }
}

