/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.pcep.spi.EROSubobjectRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.Subobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEROWithSubobjectsParser
implements ObjectParser,
ObjectSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEROWithSubobjectsParser.class);
    private static final int HEADER_LENGTH = 2;
    private final EROSubobjectRegistry subobjReg;

    protected AbstractEROWithSubobjectsParser(EROSubobjectRegistry subobjReg) {
        this.subobjReg = Objects.requireNonNull(subobjReg);
    }

    protected List<Subobject> parseSubobjects(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null, "Array of bytes is mandatory. Can't be null.");
        ArrayList<Subobject> subs = new ArrayList<Subobject>();
        while (buffer.isReadable()) {
            boolean loose = (buffer.getUnsignedByte(buffer.readerIndex()) & 0x80) != 0;
            int type = buffer.readUnsignedByte() & 0xFF & 0xFFFFFF7F;
            int length = buffer.readUnsignedByte() - 2;
            if (length > buffer.readableBytes()) {
                throw new PCEPDeserializerException("Wrong length specified. Passed: " + length + "; Expected: <= " + buffer.readableBytes());
            }
            LOG.debug("Attempt to parse subobject from bytes: {}", (Object)ByteBufUtil.hexDump(buffer));
            Subobject sub = this.subobjReg.parseSubobject(type, buffer.readSlice(length), loose);
            if (sub == null) {
                LOG.warn("Unknown subobject type: {}. Ignoring subobject.", (Object)type);
                continue;
            }
            LOG.debug("Subobject was parsed. {}", (Object)sub);
            subs.add(sub);
        }
        return subs;
    }

    protected final void serializeSubobject(List<Subobject> subobjects, ByteBuf buffer) {
        if (subobjects != null) {
            for (Subobject subobject : subobjects) {
                this.subobjReg.serializeSubobject(subobject, buffer);
            }
        }
    }
}

