/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object.LoadBalancingBuilder;

public class PCEPLoadBalancingObjectParser
implements ObjectParser,
ObjectSerializer {
    public static final int CLASS = 14;
    public static final int TYPE = 1;
    private static final int RESERVED = 2;
    private static final int FLAGS_F_LENGTH = 1;
    private static final int SIZE = 8;

    @Override
    public LoadBalancing parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() != 8) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected: " + 8 + ".");
        }
        LoadBalancingBuilder builder = new LoadBalancingBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        bytes.skipBytes(3);
        builder.setMaxLsp(bytes.readUnsignedByte());
        builder.setMinBandwidth(new Bandwidth(ByteArray.readAllBytes(bytes)));
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof LoadBalancing, "Wrong instance of PCEPObject. Passed %s. Needed LoadBalancingObject.", object.getClass());
        LoadBalancing specObj = (LoadBalancing)object;
        ByteBuf body = Unpooled.buffer(8);
        body.writeZero(3);
        ByteBufWriteUtil.writeUnsignedByte(specObj.getMaxLsp(), body);
        ByteBufWriteUtil.writeFloat32(specObj.getMinBandwidth(), body);
        ObjectUtil.formatSubobject(1, 14, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

