/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.parser.object.AbstractEROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.PathKeyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key.PathKeys;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key.PathKeysBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCaseBuilder;

public class PCEPPathKeyObjectParser
extends AbstractEROWithSubobjectsParser {
    public static final int CLASS = 16;
    public static final int TYPE = 1;

    public PCEPPathKeyObjectParser(EROSubobjectRegistry subReg) {
        super(subReg);
    }

    @Override
    public PathKey parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        PathKeyBuilder builder = new PathKeyBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        ArrayList<PathKeys> pk = new ArrayList<PathKeys>();
        List<Subobject> subs = this.parseSubobjects(bytes);
        for (Subobject s : subs) {
            PathKeyCase k = (PathKeyCase)s.getSubobjectType();
            pk.add(new PathKeysBuilder().setLoose(s.isLoose()).setPceId(k.getPathKey().getPceId()).setPathKey(k.getPathKey().getPathKey()).build());
        }
        builder.setPathKeys(pk);
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof PathKey, "Wrong instance of PCEPObject. Passed %s. Needed PathKeyObject.", object.getClass());
        PathKey pkey = (PathKey)object;
        ByteBuf body = Unpooled.buffer();
        List<PathKeys> pk = pkey.getPathKeys();
        ArrayList<Subobject> subs = new ArrayList<Subobject>();
        for (PathKeys p : pk) {
            subs.add(new SubobjectBuilder().setLoose(p.isLoose()).setSubobjectType(new PathKeyCaseBuilder().setPathKey(new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.path.key._case.PathKeyBuilder().setPathKey(p.getPathKey()).setPceId(p.getPceId()).build()).build()).build());
        }
        this.serializeSubobject(subs, body);
        ObjectUtil.formatSubobject(1, 16, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

