/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.EROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.EROSubobjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.path.key._case.PathKeyBuilder;

public abstract class AbstractEROPathKeySubobjectParser
implements EROSubobjectParser,
EROSubobjectSerializer {
    public static final int TYPE_32 = 64;
    public static final int TYPE_128 = 65;
    protected static final int PCE_ID_F_LENGTH = 4;
    protected static final int PCE128_ID_F_LENGTH = 16;
    protected static final int CONTENT128_LENGTH = 18;
    protected static final int CONTENT_LENGTH = 6;

    protected abstract byte[] readPceId(ByteBuf var1);

    protected abstract void checkContentLenght(int var1) throws PCEPDeserializerException;

    @Override
    public final Subobject parseSubobject(ByteBuf buffer, boolean loose) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        this.checkContentLenght(buffer.readableBytes());
        int pathKey = buffer.readUnsignedShort();
        byte[] pceId = this.readPceId(buffer);
        PathKeyBuilder pBuilder = new PathKeyBuilder();
        pBuilder.setPceId(new PceId(pceId));
        pBuilder.setPathKey(new PathKey(pathKey));
        SubobjectBuilder builder = new SubobjectBuilder();
        builder.setLoose(loose);
        builder.setSubobjectType(new PathKeyCaseBuilder().setPathKey(pBuilder.build()).build());
        return builder.build();
    }

    @Override
    public final void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject.getSubobjectType() instanceof PathKeyCase, "Unknown subobject instance. Passed %s. Needed PathKey.", subobject.getSubobjectType().getClass());
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.path.key._case.PathKey pk = ((PathKeyCase)subobject.getSubobjectType()).getPathKey();
        Preconditions.checkArgument(pk.getPceId() != null, "PceId is mandatory.");
        Preconditions.checkArgument(pk.getPathKey() != null, "PathKey is mandatory.");
        byte[] pceID = pk.getPceId().getBinary();
        Preconditions.checkArgument(pceID.length == 4 || pceID.length == 16, "PceId 32/128 Bit required.");
        ByteBuf body = Unpooled.buffer();
        ByteBufWriteUtil.writeUnsignedShort(pk.getPathKey().getValue(), body);
        body.writeBytes(pceID);
        EROSubobjectUtil.formatSubobject(pceID.length == 4 ? 64 : 65, subobject.isLoose(), body, buffer);
    }
}

