/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.sync.optimizations;

import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.ietf.initiated00.CInitiated00StatefulCapabilityTlvParser;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev171025.Stateful1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev171025.Stateful1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.stateful.capability.tlv.Stateful;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.stateful.capability.tlv.StatefulBuilder;

public class SyncOptimizationsCapabilityTlvParser
extends CInitiated00StatefulCapabilityTlvParser {
    protected static final int S_FLAG_OFFSET = 30;
    protected static final int T_FLAG_OFFSET = 28;
    protected static final int D_FLAG_OFFSET = 27;
    protected static final int F_FLAG_OFFSET = 26;

    @Override
    protected void parseFlags(StatefulBuilder sb, ByteBuf buffer) {
        BitArray flags = BitArray.valueOf(buffer, 32);
        sb.setLspUpdateCapability(flags.get(31));
        if (flags.get(29)) {
            sb.addAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev171025.Stateful1.class, new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev171025.Stateful1Builder().setInitiation(Boolean.TRUE).build());
        }
        Stateful1Builder syncOptBuilder = new Stateful1Builder();
        if (flags.get(30)) {
            syncOptBuilder.setIncludeDbVersion(Boolean.TRUE);
        }
        if (flags.get(28)) {
            syncOptBuilder.setTriggeredResync(Boolean.TRUE);
        }
        if (flags.get(27)) {
            syncOptBuilder.setDeltaLspSyncCapability(Boolean.TRUE);
        }
        if (flags.get(26)) {
            syncOptBuilder.setTriggeredInitialSync(Boolean.TRUE);
        }
        sb.addAugmentation(Stateful1.class, syncOptBuilder.build());
    }

    @Override
    protected BitArray serializeFlags(Stateful sct) {
        BitArray flags = new BitArray(32);
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev171025.Stateful1 sfi = sct.getAugmentation(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.initiated.rev171025.Stateful1.class);
        Stateful1 sf2 = sct.getAugmentation(Stateful1.class);
        if (sf2 != null) {
            flags.set(26, sf2.isTriggeredInitialSync());
            flags.set(27, sf2.isDeltaLspSyncCapability());
            flags.set(28, sf2.isTriggeredResync());
            flags.set(30, sf2.isIncludeDbVersion());
        }
        if (sfi != null) {
            flags.set(29, sfi.isInitiation());
        }
        flags.set(31, sct.isLspUpdateCapability());
        return flags;
    }
}

