/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import java.util.Objects;

public final class BitArray {
    private final int size;
    private final byte[] backingArray;
    private final int offset;

    public BitArray(int size) {
        Preconditions.checkArgument(size >= 1, "Minimum size is 1 bit.");
        this.size = size;
        this.backingArray = new byte[BitArray.calculateBytes(size)];
        this.offset = BitArray.calculateBytes(this.size) * 8 - this.size;
    }

    private BitArray(byte[] backingArray, int size) {
        Objects.requireNonNull(backingArray, "Byte Array cannot be null");
        this.size = size;
        this.backingArray = (byte[])backingArray.clone();
        this.offset = BitArray.calculateBytes(this.size) * 8 - this.size;
    }

    public static BitArray valueOf(ByteBuf buffer, int size) {
        Preconditions.checkArgument(size >= 1, "Minimum size is 1 bit.");
        Objects.requireNonNull(buffer, "Byte Array cannot be null");
        byte[] b = new byte[BitArray.calculateBytes(size)];
        buffer.readBytes(b, 0, b.length);
        return new BitArray(b, size);
    }

    public static BitArray valueOf(byte[] bytes) {
        return new BitArray(bytes, bytes.length);
    }

    public static BitArray valueOf(byte info) {
        return new BitArray(new byte[]{info}, 8);
    }

    private static int calculateBytes(int size) {
        return (size + 8 - 1) / 8;
    }

    public void set(int index, Boolean value) {
        Preconditions.checkArgument(index < this.size, "Index out of bounds.");
        if (value == null || value.equals(Boolean.FALSE)) {
            return;
        }
        int pos = this.calculatePosition(index);
        byte b = this.backingArray[pos];
        this.backingArray[pos] = (byte)(UnsignedBytes.toInt(b) | this.mask(index));
    }

    public boolean get(int index) {
        Preconditions.checkArgument(index < this.size, "Index out of bounds.");
        byte b = this.backingArray[this.calculatePosition(index)];
        return (byte)(UnsignedBytes.toInt(b) & this.mask(index)) != 0;
    }

    public byte[] array() {
        return (byte[])this.backingArray.clone();
    }

    public byte toByte() {
        Preconditions.checkArgument(8 >= this.size, "Cannot put backing array to a single byte.");
        return this.backingArray[0];
    }

    public void toByteBuf(ByteBuf buffer) {
        buffer.writeBytes(this.backingArray);
    }

    private int calculatePosition(int index) {
        return (index + this.offset) / 8;
    }

    private byte mask(int index) {
        return (byte)(1 << (this.size - 1 - index) % 8);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("BitArray [");
        for (int i = 0; i < this.backingArray.length; ++i) {
            b.append(Integer.toBinaryString(UnsignedBytes.toInt(this.backingArray[i])));
            if (i == this.backingArray.length - 1) continue;
            b.append(' ');
        }
        b.append(']');
        return b.toString();
    }
}

