/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCEPHexDumpParser {
    private static final int MINIMAL_LENGTH = 4;
    private static final Logger LOG = LoggerFactory.getLogger(PCEPHexDumpParser.class);
    private static final String LENGTH = "LENGTH:";

    private PCEPHexDumpParser() {
        throw new UnsupportedOperationException();
    }

    public static List<byte[]> parseMessages(File file) throws IOException {
        Preconditions.checkArgument(file != null, "Filename cannot be null");
        return PCEPHexDumpParser.parseMessages(new FileInputStream(file));
    }

    public static List<byte[]> parseMessages(InputStream is) throws IOException {
        Objects.requireNonNull(is);
        try (InputStreamReader isr = new InputStreamReader(is, "UTF-8");){
            List<byte[]> list = PCEPHexDumpParser.parseMessages(CharStreams.toString(isr));
            return list;
        }
    }

    private static List<byte[]> parseMessages(String msg) {
        String content = PCEPHexDumpParser.clearWhiteSpaceToUpper(msg);
        LinkedList<byte[]> messages = Lists.newLinkedList();
        int idx = content.indexOf(LENGTH, 0);
        while (idx > -1) {
            int lengthIdx = idx + LENGTH.length();
            int messageIdx = content.indexOf(46, lengthIdx);
            int length = Integer.parseInt(content.substring(lengthIdx, messageIdx));
            int messageEndIdx = messageIdx + length * 2 + 1;
            Preconditions.checkArgument(length >= 4, "Invalid message at index " + idx + ", length atribute is lower than " + 4);
            String hexMessage = content.substring(messageIdx + 1, messageEndIdx);
            byte[] message = BaseEncoding.base16().decode(hexMessage);
            messages.add(message);
            idx = messageEndIdx;
            idx = content.indexOf(LENGTH, idx);
        }
        LOG.info("Succesfully extracted {} messages", (Object)messages.size());
        return messages;
    }

    private static String clearWhiteSpaceToUpper(String line) {
        return line.replaceAll("\\s", "").toUpperCase(Locale.ENGLISH);
    }
}

